// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Security details for OpenApi anonymous authentication.
 */
@Immutable
public final class OpenApiAnonymousAuthDetails extends OpenApiAuthDetails {

    /*
     * The type of authentication, must be anonymous/connection/managed_identity
     */
    @Generated
    private OpenApiAuthType type = OpenApiAuthType.ANONYMOUS;

    /**
     * Creates an instance of OpenApiAnonymousAuthDetails class.
     */
    @Generated
    public OpenApiAnonymousAuthDetails() {
    }

    /**
     * Get the type property: The type of authentication, must be anonymous/connection/managed_identity.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public OpenApiAuthType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenApiAnonymousAuthDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenApiAnonymousAuthDetails if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OpenApiAnonymousAuthDetails.
     */
    @Generated
    public static OpenApiAnonymousAuthDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenApiAnonymousAuthDetails deserializedOpenApiAnonymousAuthDetails = new OpenApiAnonymousAuthDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedOpenApiAnonymousAuthDetails.type = OpenApiAuthType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedOpenApiAnonymousAuthDetails;
        });
    }
}
