// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * authentication details for OpenApiFunctionDefinition.
 */
@Immutable
public class OpenApiAuthDetails implements JsonSerializable<OpenApiAuthDetails> {

    /*
     * The type of authentication, must be anonymous/connection/managed_identity
     */
    @Generated
    private OpenApiAuthType type = OpenApiAuthType.fromString("OpenApiAuthDetails");

    /**
     * Creates an instance of OpenApiAuthDetails class.
     */
    @Generated
    public OpenApiAuthDetails() {
    }

    /**
     * Get the type property: The type of authentication, must be anonymous/connection/managed_identity.
     *
     * @return the type value.
     */
    @Generated
    public OpenApiAuthType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenApiAuthDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenApiAuthDetails if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the OpenApiAuthDetails.
     */
    @Generated
    public static OpenApiAuthDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("anonymous".equals(discriminatorValue)) {
                    return OpenApiAnonymousAuthDetails.fromJson(readerToUse.reset());
                } else if ("connection".equals(discriminatorValue)) {
                    return OpenApiConnectionAuthDetails.fromJson(readerToUse.reset());
                } else if ("managed_identity".equals(discriminatorValue)) {
                    return OpenApiManagedAuthDetails.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static OpenApiAuthDetails fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenApiAuthDetails deserializedOpenApiAuthDetails = new OpenApiAuthDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedOpenApiAuthDetails.type = OpenApiAuthType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedOpenApiAuthDetails;
        });
    }
}
