// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Authentication type for OpenApi endpoint. Allowed types are:
 * - Anonymous (no authentication required)
 * - Connection (requires connection_id to endpoint, as setup in AI Foundry)
 * - Managed_Identity (requires audience for identity based auth).
 */
public final class OpenApiAuthType extends ExpandableStringEnum<OpenApiAuthType> {

    /**
     * Static value anonymous for OpenApiAuthType.
     */
    @Generated
    public static final OpenApiAuthType ANONYMOUS = fromString("anonymous");

    /**
     * Static value connection for OpenApiAuthType.
     */
    @Generated
    public static final OpenApiAuthType CONNECTION = fromString("connection");

    /**
     * Static value managed_identity for OpenApiAuthType.
     */
    @Generated
    public static final OpenApiAuthType MANAGED_IDENTITY = fromString("managed_identity");

    /**
     * Creates a new instance of OpenApiAuthType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public OpenApiAuthType() {
    }

    /**
     * Creates or finds a OpenApiAuthType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding OpenApiAuthType.
     */
    @Generated
    public static OpenApiAuthType fromString(String name) {
        return fromString(name, OpenApiAuthType.class);
    }

    /**
     * Gets known OpenApiAuthType values.
     *
     * @return known OpenApiAuthType values.
     */
    @Generated
    public static Collection<OpenApiAuthType> values() {
        return values(OpenApiAuthType.class);
    }
}
