// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Security details for OpenApi connection authentication.
 */
@Immutable
public final class OpenApiConnectionAuthDetails extends OpenApiAuthDetails {

    /*
     * The type of authentication, must be anonymous/connection/managed_identity
     */
    @Generated
    private OpenApiAuthType type = OpenApiAuthType.CONNECTION;

    /*
     * Connection auth security details
     */
    @Generated
    private final OpenApiConnectionSecurityScheme securityScheme;

    /**
     * Creates an instance of OpenApiConnectionAuthDetails class.
     *
     * @param securityScheme the securityScheme value to set.
     */
    @Generated
    public OpenApiConnectionAuthDetails(OpenApiConnectionSecurityScheme securityScheme) {
        this.securityScheme = securityScheme;
    }

    /**
     * Get the type property: The type of authentication, must be anonymous/connection/managed_identity.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public OpenApiAuthType getType() {
        return this.type;
    }

    /**
     * Get the securityScheme property: Connection auth security details.
     *
     * @return the securityScheme value.
     */
    @Generated
    public OpenApiConnectionSecurityScheme getSecurityScheme() {
        return this.securityScheme;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("security_scheme", this.securityScheme);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenApiConnectionAuthDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenApiConnectionAuthDetails if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OpenApiConnectionAuthDetails.
     */
    @Generated
    public static OpenApiConnectionAuthDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenApiConnectionSecurityScheme securityScheme = null;
            OpenApiAuthType type = OpenApiAuthType.CONNECTION;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("security_scheme".equals(fieldName)) {
                    securityScheme = OpenApiConnectionSecurityScheme.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = OpenApiAuthType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            OpenApiConnectionAuthDetails deserializedOpenApiConnectionAuthDetails
                = new OpenApiConnectionAuthDetails(securityScheme);
            deserializedOpenApiConnectionAuthDetails.type = type;
            return deserializedOpenApiConnectionAuthDetails;
        });
    }
}
