// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Security scheme for OpenApi managed_identity authentication.
 */
@Immutable
public final class OpenApiConnectionSecurityScheme implements JsonSerializable<OpenApiConnectionSecurityScheme> {

    /*
     * Connection id for Connection auth type
     */
    @Generated
    private final String connectionId;

    /**
     * Creates an instance of OpenApiConnectionSecurityScheme class.
     *
     * @param connectionId the connectionId value to set.
     */
    @Generated
    public OpenApiConnectionSecurityScheme(String connectionId) {
        this.connectionId = connectionId;
    }

    /**
     * Get the connectionId property: Connection id for Connection auth type.
     *
     * @return the connectionId value.
     */
    @Generated
    public String getConnectionId() {
        return this.connectionId;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connection_id", this.connectionId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenApiConnectionSecurityScheme from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenApiConnectionSecurityScheme if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OpenApiConnectionSecurityScheme.
     */
    @Generated
    public static OpenApiConnectionSecurityScheme fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String connectionId = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connection_id".equals(fieldName)) {
                    connectionId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return new OpenApiConnectionSecurityScheme(connectionId);
        });
    }
}
