// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The input definition information for an openapi function.
 */
@Fluent
public final class OpenApiFunctionDefinition implements JsonSerializable<OpenApiFunctionDefinition> {

    /*
     * The name of the function to be called.
     */
    @Generated
    private final String name;

    /*
     * A description of what the function does, used by the model to choose when and how to call the function.
     */
    @Generated
    private String description;

    /*
     * The openapi function shape, described as a JSON Schema object.
     */
    @Generated
    private final BinaryData spec;

    /*
     * Open API authentication details
     */
    @Generated
    private final OpenApiAuthDetails auth;

    /*
     * List of OpenAPI spec parameters that will use user-provided defaults
     */
    @Generated
    private List<String> defaultParams;

    /*
     * List of function definitions used by OpenApi tool
     */
    @Generated
    private List<FunctionDefinition> functions;

    /**
     * Creates an instance of OpenApiFunctionDefinition class.
     *
     * @param name the name value to set.
     * @param spec the spec value to set.
     * @param auth the auth value to set.
     */
    @Generated
    public OpenApiFunctionDefinition(String name, BinaryData spec, OpenApiAuthDetails auth) {
        this.name = name;
        this.spec = spec;
        this.auth = auth;
    }

    /**
     * Get the name property: The name of the function to be called.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the description property: A description of what the function does, used by the model to choose when and how
     * to call the function.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: A description of what the function does, used by the model to choose when and how
     * to call the function.
     *
     * @param description the description value to set.
     * @return the OpenApiFunctionDefinition object itself.
     */
    @Generated
    public OpenApiFunctionDefinition setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the spec property: The openapi function shape, described as a JSON Schema object.
     *
     * @return the spec value.
     */
    @Generated
    public BinaryData getSpec() {
        return this.spec;
    }

    /**
     * Get the auth property: Open API authentication details.
     *
     * @return the auth value.
     */
    @Generated
    public OpenApiAuthDetails getAuth() {
        return this.auth;
    }

    /**
     * Get the defaultParams property: List of OpenAPI spec parameters that will use user-provided defaults.
     *
     * @return the defaultParams value.
     */
    @Generated
    public List<String> getDefaultParams() {
        return this.defaultParams;
    }

    /**
     * Set the defaultParams property: List of OpenAPI spec parameters that will use user-provided defaults.
     *
     * @param defaultParams the defaultParams value to set.
     * @return the OpenApiFunctionDefinition object itself.
     */
    @Generated
    public OpenApiFunctionDefinition setDefaultParams(List<String> defaultParams) {
        this.defaultParams = defaultParams;
        return this;
    }

    /**
     * Get the functions property: List of function definitions used by OpenApi tool.
     *
     * @return the functions value.
     */
    @Generated
    public List<FunctionDefinition> getFunctions() {
        return this.functions;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeFieldName("spec");
        this.spec.writeTo(jsonWriter);
        jsonWriter.writeJsonField("auth", this.auth);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("default_params", this.defaultParams,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenApiFunctionDefinition from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenApiFunctionDefinition if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OpenApiFunctionDefinition.
     */
    @Generated
    public static OpenApiFunctionDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String name = null;
            BinaryData spec = null;
            OpenApiAuthDetails auth = null;
            String description = null;
            List<String> defaultParams = null;
            List<FunctionDefinition> functions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("spec".equals(fieldName)) {
                    spec = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("auth".equals(fieldName)) {
                    auth = OpenApiAuthDetails.fromJson(reader);
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("default_params".equals(fieldName)) {
                    defaultParams = reader.readArray(reader1 -> reader1.getString());
                } else if ("functions".equals(fieldName)) {
                    functions = reader.readArray(reader1 -> FunctionDefinition.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            OpenApiFunctionDefinition deserializedOpenApiFunctionDefinition
                = new OpenApiFunctionDefinition(name, spec, auth);
            deserializedOpenApiFunctionDefinition.description = description;
            deserializedOpenApiFunctionDefinition.defaultParams = defaultParams;
            deserializedOpenApiFunctionDefinition.functions = functions;
            return deserializedOpenApiFunctionDefinition;
        });
    }
}
