// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Security scheme for OpenApi managed_identity authentication.
 */
@Immutable
public final class OpenApiManagedSecurityScheme implements JsonSerializable<OpenApiManagedSecurityScheme> {

    /*
     * Authentication scope for managed_identity auth type
     */
    @Generated
    private final String audience;

    /**
     * Creates an instance of OpenApiManagedSecurityScheme class.
     *
     * @param audience the audience value to set.
     */
    @Generated
    public OpenApiManagedSecurityScheme(String audience) {
        this.audience = audience;
    }

    /**
     * Get the audience property: Authentication scope for managed_identity auth type.
     *
     * @return the audience value.
     */
    @Generated
    public String getAudience() {
        return this.audience;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("audience", this.audience);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenApiManagedSecurityScheme from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenApiManagedSecurityScheme if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OpenApiManagedSecurityScheme.
     */
    @Generated
    public static OpenApiManagedSecurityScheme fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String audience = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("audience".equals(fieldName)) {
                    audience = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return new OpenApiManagedSecurityScheme(audience);
        });
    }
}
