// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The input definition information for an OpenAPI tool as used to configure an agent.
 */
@Immutable
public final class OpenApiToolDefinition extends ToolDefinition {

    /*
     * The object type.
     */
    @Generated
    private String type = "openapi";

    /*
     * The openapi function definition.
     */
    @Generated
    private final OpenApiFunctionDefinition openapi;

    /**
     * Creates an instance of OpenApiToolDefinition class.
     *
     * @param openapi the openapi value to set.
     */
    @Generated
    public OpenApiToolDefinition(OpenApiFunctionDefinition openapi) {
        this.openapi = openapi;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the openapi property: The openapi function definition.
     *
     * @return the openapi value.
     */
    @Generated
    public OpenApiFunctionDefinition getOpenapi() {
        return this.openapi;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("openapi", this.openapi);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenApiToolDefinition from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenApiToolDefinition if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OpenApiToolDefinition.
     */
    @Generated
    public static OpenApiToolDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenApiFunctionDefinition openapi = null;
            String type = "openapi";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("openapi".equals(fieldName)) {
                    openapi = OpenApiFunctionDefinition.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            OpenApiToolDefinition deserializedOpenApiToolDefinition = new OpenApiToolDefinition(openapi);
            deserializedOpenApiToolDefinition.type = type;
            return deserializedOpenApiToolDefinition;
        });
    }
}
