// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;

/**
 * Represents an agent that can call the model and use tools.
 */
@Immutable
public final class PersistentAgent implements JsonSerializable<PersistentAgent> {

    /*
     * The identifier, which can be referenced in API endpoints.
     */
    @Generated
    private final String id;

    /*
     * The object type, which is always assistant.
     */
    @Generated
    private final String object = "assistant";

    /*
     * The Unix timestamp, in seconds, representing when this object was created.
     */
    @Generated
    private final long createdAt;

    /*
     * The name of the agent.
     */
    @Generated
    private final String name;

    /*
     * The description of the agent.
     */
    @Generated
    private final String description;

    /*
     * The ID of the model to use.
     */
    @Generated
    private final String model;

    /*
     * The system instructions for the agent to use.
     */
    @Generated
    private final String instructions;

    /*
     * The collection of tools enabled for the agent.
     */
    @Generated
    private final List<ToolDefinition> tools;

    /*
     * A set of resources that are used by the agent's tools. The resources are specific to the type of tool. For
     * example, the `code_interpreter`
     * tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.
     */
    @Generated
    private final ToolResources toolResources;

    /*
     * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random,
     * while lower values like 0.2 will make it more focused and deterministic.
     */
    @Generated
    private final Double temperature;

    /*
     * An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of
     * the tokens with top_p probability mass.
     * So 0.1 means only the tokens comprising the top 10% probability mass are considered.
     * 
     * We generally recommend altering this or temperature but not both.
     */
    @Generated
    private final Double topP;

    /*
     * The response format of the tool calls used by this agent.
     */
    @Generated
    private BinaryData responseFormat;

    /*
     * A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information
     * about that object in a structured format. Keys may be up to 64 characters in length and values may be up to 512
     * characters in length.
     */
    @Generated
    private final Map<String, String> metadata;

    /**
     * Creates an instance of PersistentAgent class.
     *
     * @param id the id value to set.
     * @param createdAt the createdAt value to set.
     * @param name the name value to set.
     * @param description the description value to set.
     * @param model the model value to set.
     * @param instructions the instructions value to set.
     * @param tools the tools value to set.
     * @param toolResources the toolResources value to set.
     * @param temperature the temperature value to set.
     * @param topP the topP value to set.
     * @param metadata the metadata value to set.
     */
    @Generated
    private PersistentAgent(String id, OffsetDateTime createdAt, String name, String description, String model,
        String instructions, List<ToolDefinition> tools, ToolResources toolResources, Double temperature, Double topP,
        Map<String, String> metadata) {
        this.id = id;
        if (createdAt == null) {
            this.createdAt = 0L;
        } else {
            this.createdAt = createdAt.toEpochSecond();
        }
        this.name = name;
        this.description = description;
        this.model = model;
        this.instructions = instructions;
        this.tools = tools;
        this.toolResources = toolResources;
        this.temperature = temperature;
        this.topP = topP;
        this.metadata = metadata;
    }

    /**
     * Get the id property: The identifier, which can be referenced in API endpoints.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the object property: The object type, which is always assistant.
     *
     * @return the object value.
     */
    @Generated
    public String getObject() {
        return this.object;
    }

    /**
     * Get the createdAt property: The Unix timestamp, in seconds, representing when this object was created.
     *
     * @return the createdAt value.
     */
    @Generated
    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    /**
     * Get the name property: The name of the agent.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the description property: The description of the agent.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Get the model property: The ID of the model to use.
     *
     * @return the model value.
     */
    @Generated
    public String getModel() {
        return this.model;
    }

    /**
     * Get the instructions property: The system instructions for the agent to use.
     *
     * @return the instructions value.
     */
    @Generated
    public String getInstructions() {
        return this.instructions;
    }

    /**
     * Get the tools property: The collection of tools enabled for the agent.
     *
     * @return the tools value.
     */
    @Generated
    public List<ToolDefinition> getTools() {
        return this.tools;
    }

    /**
     * Get the toolResources property: A set of resources that are used by the agent's tools. The resources are specific
     * to the type of tool. For example, the `code_interpreter`
     * tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.
     *
     * @return the toolResources value.
     */
    @Generated
    public ToolResources getToolResources() {
        return this.toolResources;
    }

    /**
     * Get the temperature property: What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make
     * the output more random,
     * while lower values like 0.2 will make it more focused and deterministic.
     *
     * @return the temperature value.
     */
    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    /**
     * Get the topP property: An alternative to sampling with temperature, called nucleus sampling, where the model
     * considers the results of the tokens with top_p probability mass.
     * So 0.1 means only the tokens comprising the top 10% probability mass are considered.
     *
     * We generally recommend altering this or temperature but not both.
     *
     * @return the topP value.
     */
    @Generated
    public Double getTopP() {
        return this.topP;
    }

    /**
     * Get the responseFormat property: The response format of the tool calls used by this agent.
     *
     * @return the responseFormat value.
     */
    @Generated
    public BinaryData getResponseFormat() {
        return this.responseFormat;
    }

    /**
     * Get the metadata property: A set of up to 16 key/value pairs that can be attached to an object, used for storing
     * additional information about that object in a structured format. Keys may be up to 64 characters in length and
     * values may be up to 512 characters in length.
     *
     * @return the metadata value.
     */
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("instructions", this.instructions);
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("tool_resources", this.toolResources);
        jsonWriter.writeNumberField("temperature", this.temperature);
        jsonWriter.writeNumberField("top_p", this.topP);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        if (this.responseFormat != null) {
            jsonWriter.writeFieldName("response_format");
            this.responseFormat.writeTo(jsonWriter);
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PersistentAgent from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of PersistentAgent if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PersistentAgent.
     */
    @Generated
    public static PersistentAgent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            String name = null;
            String description = null;
            String model = null;
            String instructions = null;
            List<ToolDefinition> tools = null;
            ToolResources toolResources = null;
            Double temperature = null;
            Double topP = null;
            Map<String, String> metadata = null;
            BinaryData responseFormat = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("model".equals(fieldName)) {
                    model = reader.getString();
                } else if ("instructions".equals(fieldName)) {
                    instructions = reader.getString();
                } else if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ToolDefinition.fromJson(reader1));
                } else if ("tool_resources".equals(fieldName)) {
                    toolResources = ToolResources.fromJson(reader);
                } else if ("temperature".equals(fieldName)) {
                    temperature = reader.getNullable(JsonReader::getDouble);
                } else if ("top_p".equals(fieldName)) {
                    topP = reader.getNullable(JsonReader::getDouble);
                } else if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                } else if ("response_format".equals(fieldName)) {
                    responseFormat
                        = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else {
                    reader.skipChildren();
                }
            }
            PersistentAgent deserializedPersistentAgent = new PersistentAgent(id, createdAt, name, description, model,
                instructions, tools, toolResources, temperature, topP, metadata);
            deserializedPersistentAgent.responseFormat = responseFormat;
            return deserializedPersistentAgent;
        });
    }
}
