// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The details used to create a new agent thread.
 */
@Fluent
public final class PersistentAgentThreadCreationOptions
    implements JsonSerializable<PersistentAgentThreadCreationOptions> {

    /*
     * The initial messages to associate with the new thread.
     */
    @Generated
    private List<ThreadMessageOptions> messages;

    /*
     * A set of resources that are made available to the agent's tools in this thread. The resources are specific to the
     * type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool
     * requires
     * a list of vector store IDs.
     */
    @Generated
    private ToolResources toolResources;

    /*
     * A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information
     * about that object in a structured format. Keys may be up to 64 characters in length and values may be up to 512
     * characters in length.
     */
    @Generated
    private Map<String, String> metadata;

    /**
     * Creates an instance of PersistentAgentThreadCreationOptions class.
     */
    @Generated
    public PersistentAgentThreadCreationOptions() {
    }

    /**
     * Get the messages property: The initial messages to associate with the new thread.
     *
     * @return the messages value.
     */
    @Generated
    public List<ThreadMessageOptions> getMessages() {
        return this.messages;
    }

    /**
     * Set the messages property: The initial messages to associate with the new thread.
     *
     * @param messages the messages value to set.
     * @return the PersistentAgentThreadCreationOptions object itself.
     */
    @Generated
    public PersistentAgentThreadCreationOptions setMessages(List<ThreadMessageOptions> messages) {
        this.messages = messages;
        return this;
    }

    /**
     * Get the toolResources property: A set of resources that are made available to the agent's tools in this thread.
     * The resources are specific to the
     * type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool
     * requires
     * a list of vector store IDs.
     *
     * @return the toolResources value.
     */
    @Generated
    public ToolResources getToolResources() {
        return this.toolResources;
    }

    /**
     * Set the toolResources property: A set of resources that are made available to the agent's tools in this thread.
     * The resources are specific to the
     * type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool
     * requires
     * a list of vector store IDs.
     *
     * @param toolResources the toolResources value to set.
     * @return the PersistentAgentThreadCreationOptions object itself.
     */
    @Generated
    public PersistentAgentThreadCreationOptions setToolResources(ToolResources toolResources) {
        this.toolResources = toolResources;
        return this;
    }

    /**
     * Get the metadata property: A set of up to 16 key/value pairs that can be attached to an object, used for storing
     * additional information about that object in a structured format. Keys may be up to 64 characters in length and
     * values may be up to 512 characters in length.
     *
     * @return the metadata value.
     */
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: A set of up to 16 key/value pairs that can be attached to an object, used for storing
     * additional information about that object in a structured format. Keys may be up to 64 characters in length and
     * values may be up to 512 characters in length.
     *
     * @param metadata the metadata value to set.
     * @return the PersistentAgentThreadCreationOptions object itself.
     */
    @Generated
    public PersistentAgentThreadCreationOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("messages", this.messages, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("tool_resources", this.toolResources);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PersistentAgentThreadCreationOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of PersistentAgentThreadCreationOptions if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PersistentAgentThreadCreationOptions.
     */
    @Generated
    public static PersistentAgentThreadCreationOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PersistentAgentThreadCreationOptions deserializedPersistentAgentThreadCreationOptions
                = new PersistentAgentThreadCreationOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("messages".equals(fieldName)) {
                    List<ThreadMessageOptions> messages
                        = reader.readArray(reader1 -> ThreadMessageOptions.fromJson(reader1));
                    deserializedPersistentAgentThreadCreationOptions.messages = messages;
                } else if ("tool_resources".equals(fieldName)) {
                    deserializedPersistentAgentThreadCreationOptions.toolResources = ToolResources.fromJson(reader);
                } else if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedPersistentAgentThreadCreationOptions.metadata = metadata;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedPersistentAgentThreadCreationOptions;
        });
    }
}
