// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies a tool the model should use. Use to force the model to call a specific tool.
 */
@Fluent
public final class PersistentAgentsNamedToolChoice implements JsonSerializable<PersistentAgentsNamedToolChoice> {

    /*
     * the type of tool. If type is `function`, the function name must be set.
     */
    @Generated
    private final PersistentAgentsNamedToolChoiceType type;

    /*
     * The name of the function to call
     */
    @Generated
    private FunctionName function;

    /**
     * Creates an instance of PersistentAgentsNamedToolChoice class.
     *
     * @param type the type value to set.
     */
    @Generated
    public PersistentAgentsNamedToolChoice(PersistentAgentsNamedToolChoiceType type) {
        this.type = type;
    }

    /**
     * Get the type property: the type of tool. If type is `function`, the function name must be set.
     *
     * @return the type value.
     */
    @Generated
    public PersistentAgentsNamedToolChoiceType getType() {
        return this.type;
    }

    /**
     * Get the function property: The name of the function to call.
     *
     * @return the function value.
     */
    @Generated
    public FunctionName getFunction() {
        return this.function;
    }

    /**
     * Set the function property: The name of the function to call.
     *
     * @param function the function value to set.
     * @return the PersistentAgentsNamedToolChoice object itself.
     */
    @Generated
    public PersistentAgentsNamedToolChoice setFunction(FunctionName function) {
        this.function = function;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("function", this.function);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PersistentAgentsNamedToolChoice from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of PersistentAgentsNamedToolChoice if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PersistentAgentsNamedToolChoice.
     */
    @Generated
    public static PersistentAgentsNamedToolChoice fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PersistentAgentsNamedToolChoiceType type = null;
            FunctionName function = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    type = PersistentAgentsNamedToolChoiceType.fromString(reader.getString());
                } else if ("function".equals(fieldName)) {
                    function = FunctionName.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            PersistentAgentsNamedToolChoice deserializedPersistentAgentsNamedToolChoice
                = new PersistentAgentsNamedToolChoice(type);
            deserializedPersistentAgentsNamedToolChoice.function = function;
            return deserializedPersistentAgentsNamedToolChoice;
        });
    }
}
