// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Represents the mode in which the model will handle the return format of a tool call.
 */
public final class PersistentAgentsResponseFormatMode extends ExpandableStringEnum<PersistentAgentsResponseFormatMode> {

    /**
     * Default value. Let the model handle the return format.
     */
    @Generated
    public static final PersistentAgentsResponseFormatMode AUTO = fromString("auto");

    /**
     * Setting the value to `none`, will result in a 400 Bad request.
     */
    @Generated
    public static final PersistentAgentsResponseFormatMode NONE = fromString("none");

    /**
     * Creates a new instance of PersistentAgentsResponseFormatMode value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public PersistentAgentsResponseFormatMode() {
    }

    /**
     * Creates or finds a PersistentAgentsResponseFormatMode from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding PersistentAgentsResponseFormatMode.
     */
    @Generated
    public static PersistentAgentsResponseFormatMode fromString(String name) {
        return fromString(name, PersistentAgentsResponseFormatMode.class);
    }

    /**
     * Gets known PersistentAgentsResponseFormatMode values.
     *
     * @return known PersistentAgentsResponseFormatMode values.
     */
    @Generated
    public static Collection<PersistentAgentsResponseFormatMode> values() {
        return values(PersistentAgentsResponseFormatMode.class);
    }
}
