// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A representation of a requested call to a function tool, needed by the model to continue evaluation of a run.
 */
@Immutable
public final class RequiredFunctionToolCall extends RequiredToolCall {

    /*
     * The object type for the required tool call.
     */
    @Generated
    private String type = "function";

    /*
     * Detailed information about the function to be executed by the tool that includes name and arguments.
     */
    @Generated
    private final RequiredFunctionToolCallDetails function;

    /**
     * Creates an instance of RequiredFunctionToolCall class.
     *
     * @param id the id value to set.
     * @param function the function value to set.
     */
    @Generated
    private RequiredFunctionToolCall(String id, RequiredFunctionToolCallDetails function) {
        super(id);
        this.function = function;
    }

    /**
     * Get the type property: The object type for the required tool call.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the function property: Detailed information about the function to be executed by the tool that includes name
     * and arguments.
     *
     * @return the function value.
     */
    @Generated
    public RequiredFunctionToolCallDetails getFunction() {
        return this.function;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeJsonField("function", this.function);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RequiredFunctionToolCall from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RequiredFunctionToolCall if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RequiredFunctionToolCall.
     */
    @Generated
    public static RequiredFunctionToolCall fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            RequiredFunctionToolCallDetails function = null;
            String type = "function";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("function".equals(fieldName)) {
                    function = RequiredFunctionToolCallDetails.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            RequiredFunctionToolCall deserializedRequiredFunctionToolCall = new RequiredFunctionToolCall(id, function);
            deserializedRequiredFunctionToolCall.type = type;
            return deserializedRequiredFunctionToolCall;
        });
    }
}
