// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The detailed information for a function invocation, as provided by a required action invoking a function tool, that
 * includes the name of and arguments to the function.
 */
@Immutable
public final class RequiredFunctionToolCallDetails implements JsonSerializable<RequiredFunctionToolCallDetails> {

    /*
     * The name of the function.
     */
    @Generated
    private final String name;

    /*
     * The arguments to use when invoking the named function, as provided by the model. Arguments are presented as a
     * JSON document that should be validated and parsed for evaluation.
     */
    @Generated
    private final String arguments;

    /**
     * Creates an instance of RequiredFunctionToolCallDetails class.
     *
     * @param name the name value to set.
     * @param arguments the arguments value to set.
     */
    @Generated
    private RequiredFunctionToolCallDetails(String name, String arguments) {
        this.name = name;
        this.arguments = arguments;
    }

    /**
     * Get the name property: The name of the function.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the arguments property: The arguments to use when invoking the named function, as provided by the model.
     * Arguments are presented as a JSON document that should be validated and parsed for evaluation.
     *
     * @return the arguments value.
     */
    @Generated
    public String getArguments() {
        return this.arguments;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("arguments", this.arguments);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RequiredFunctionToolCallDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RequiredFunctionToolCallDetails if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RequiredFunctionToolCallDetails.
     */
    @Generated
    public static RequiredFunctionToolCallDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String name = null;
            String arguments = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("arguments".equals(fieldName)) {
                    arguments = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return new RequiredFunctionToolCallDetails(name, arguments);
        });
    }
}
