// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Possible API response formats.
 */
public final class ResponseFormat extends ExpandableStringEnum<ResponseFormat> {

    /**
     * `text` format should be used for requests involving any sort of ToolCall.
     */
    @Generated
    public static final ResponseFormat TEXT = fromString("text");

    /**
     * Using `json_object` format will limit the usage of ToolCall to only functions.
     */
    @Generated
    public static final ResponseFormat JSON_OBJECT = fromString("json_object");

    /**
     * Creates a new instance of ResponseFormat value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public ResponseFormat() {
    }

    /**
     * Creates or finds a ResponseFormat from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ResponseFormat.
     */
    @Generated
    public static ResponseFormat fromString(String name) {
        return fromString(name, ResponseFormat.class);
    }

    /**
     * Gets known ResponseFormat values.
     *
     * @return known ResponseFormat values.
     */
    @Generated
    public static Collection<ResponseFormat> values() {
        return values(ResponseFormat.class);
    }
}
