// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A description of what the response format is for, used by the model to determine how to respond in the format.
 */
@Fluent
public final class ResponseFormatJsonSchema implements JsonSerializable<ResponseFormatJsonSchema> {

    /*
     * A description of what the response format is for, used by the model to determine how to respond in the format.
     */
    @Generated
    private String description;

    /*
     * The name of a schema.
     */
    @Generated
    private final String name;

    /*
     * The JSON schema object, describing the response format.
     */
    @Generated
    private final BinaryData schema;

    /**
     * Creates an instance of ResponseFormatJsonSchema class.
     *
     * @param name the name value to set.
     * @param schema the schema value to set.
     */
    @Generated
    public ResponseFormatJsonSchema(String name, BinaryData schema) {
        this.name = name;
        this.schema = schema;
    }

    /**
     * Get the description property: A description of what the response format is for, used by the model to determine
     * how to respond in the format.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: A description of what the response format is for, used by the model to determine
     * how to respond in the format.
     *
     * @param description the description value to set.
     * @return the ResponseFormatJsonSchema object itself.
     */
    @Generated
    public ResponseFormatJsonSchema setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the name property: The name of a schema.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the schema property: The JSON schema object, describing the response format.
     *
     * @return the schema value.
     */
    @Generated
    public BinaryData getSchema() {
        return this.schema;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeFieldName("schema");
        this.schema.writeTo(jsonWriter);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponseFormatJsonSchema from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponseFormatJsonSchema if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponseFormatJsonSchema.
     */
    @Generated
    public static ResponseFormatJsonSchema fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String name = null;
            BinaryData schema = null;
            String description = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("schema".equals(fieldName)) {
                    schema = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            ResponseFormatJsonSchema deserializedResponseFormatJsonSchema = new ResponseFormatJsonSchema(name, schema);
            deserializedResponseFormatJsonSchema.description = description;
            return deserializedResponseFormatJsonSchema;
        });
    }
}
