// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The type of response format being defined: `json_schema`.
 */
@Immutable
public final class ResponseFormatJsonSchemaType implements JsonSerializable<ResponseFormatJsonSchemaType> {

    /*
     * Type
     */
    @Generated
    private final String type = "json_schema";

    /*
     * The JSON schema, describing response format.
     */
    @Generated
    private final ResponseFormatJsonSchema jsonSchema;

    /**
     * Creates an instance of ResponseFormatJsonSchemaType class.
     *
     * @param jsonSchema the jsonSchema value to set.
     */
    @Generated
    public ResponseFormatJsonSchemaType(ResponseFormatJsonSchema jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    /**
     * Get the type property: Type.
     *
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * Get the jsonSchema property: The JSON schema, describing response format.
     *
     * @return the jsonSchema value.
     */
    @Generated
    public ResponseFormatJsonSchema getJsonSchema() {
        return this.jsonSchema;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("json_schema", this.jsonSchema);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponseFormatJsonSchemaType from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponseFormatJsonSchemaType if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponseFormatJsonSchemaType.
     */
    @Generated
    public static ResponseFormatJsonSchemaType fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResponseFormatJsonSchema jsonSchema = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("json_schema".equals(fieldName)) {
                    jsonSchema = ResponseFormatJsonSchema.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return new ResponseFormatJsonSchemaType(jsonSchema);
        });
    }
}
