// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * A record of a call to an Azure AI Search tool, issued by the model in evaluation of a defined tool, that represents
 * executed Azure AI search.
 */
@Immutable
public final class RunStepAzureAISearchToolCall extends RunStepToolCall {

    /*
     * The object type.
     */
    @Generated
    private String type = "azure_ai_search";

    /*
     * Reserved for future use.
     */
    @Generated
    private final Map<String, String> azureAISearch;

    /**
     * Creates an instance of RunStepAzureAISearchToolCall class.
     *
     * @param id the id value to set.
     * @param azureAISearch the azureAISearch value to set.
     */
    @Generated
    private RunStepAzureAISearchToolCall(String id, Map<String, String> azureAISearch) {
        super(id);
        this.azureAISearch = azureAISearch;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the azureAISearch property: Reserved for future use.
     *
     * @return the azureAISearch value.
     */
    @Generated
    public Map<String, String> getAzureAISearch() {
        return this.azureAISearch;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeMapField("azure_ai_search", this.azureAISearch,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepAzureAISearchToolCall from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepAzureAISearchToolCall if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunStepAzureAISearchToolCall.
     */
    @Generated
    public static RunStepAzureAISearchToolCall fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            Map<String, String> azureAISearch = null;
            String type = "azure_ai_search";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("azure_ai_search".equals(fieldName)) {
                    azureAISearch = reader.readMap(reader1 -> reader1.getString());
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            RunStepAzureAISearchToolCall deserializedRunStepAzureAISearchToolCall
                = new RunStepAzureAISearchToolCall(id, azureAISearch);
            deserializedRunStepAzureAISearchToolCall.type = type;
            return deserializedRunStepAzureAISearchToolCall;
        });
    }
}
