// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * A record of a call to a bing custom search tool, issued by the model in evaluation of a defined tool, that represents
 * executed search with bing custom search.
 */
@Immutable
public final class RunStepBingCustomSearchToolCall extends RunStepToolCall {

    /*
     * The object type.
     */
    @Generated
    private String type = "bing_custom_search";

    /*
     * Reserved for future use.
     */
    @Generated
    private final Map<String, String> bingCustomSearch;

    /**
     * Creates an instance of RunStepBingCustomSearchToolCall class.
     *
     * @param id the id value to set.
     * @param bingCustomSearch the bingCustomSearch value to set.
     */
    @Generated
    private RunStepBingCustomSearchToolCall(String id, Map<String, String> bingCustomSearch) {
        super(id);
        this.bingCustomSearch = bingCustomSearch;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the bingCustomSearch property: Reserved for future use.
     *
     * @return the bingCustomSearch value.
     */
    @Generated
    public Map<String, String> getBingCustomSearch() {
        return this.bingCustomSearch;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeMapField("bing_custom_search", this.bingCustomSearch,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepBingCustomSearchToolCall from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepBingCustomSearchToolCall if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunStepBingCustomSearchToolCall.
     */
    @Generated
    public static RunStepBingCustomSearchToolCall fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            Map<String, String> bingCustomSearch = null;
            String type = "bing_custom_search";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("bing_custom_search".equals(fieldName)) {
                    bingCustomSearch = reader.readMap(reader1 -> reader1.getString());
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            RunStepBingCustomSearchToolCall deserializedRunStepBingCustomSearchToolCall
                = new RunStepBingCustomSearchToolCall(id, bingCustomSearch);
            deserializedRunStepBingCustomSearchToolCall.type = type;
            return deserializedRunStepBingCustomSearchToolCall;
        });
    }
}
