// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * A record of a call to a bing grounding tool, issued by the model in evaluation of a defined tool, that represents
 * executed search with bing grounding.
 */
@Immutable
public final class RunStepBingGroundingToolCall extends RunStepToolCall {

    /*
     * The object type.
     */
    @Generated
    private String type = "bing_grounding";

    /*
     * Reserved for future use.
     */
    @Generated
    private final Map<String, String> bingGrounding;

    /**
     * Creates an instance of RunStepBingGroundingToolCall class.
     *
     * @param id the id value to set.
     * @param bingGrounding the bingGrounding value to set.
     */
    @Generated
    private RunStepBingGroundingToolCall(String id, Map<String, String> bingGrounding) {
        super(id);
        this.bingGrounding = bingGrounding;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the bingGrounding property: Reserved for future use.
     *
     * @return the bingGrounding value.
     */
    @Generated
    public Map<String, String> getBingGrounding() {
        return this.bingGrounding;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeMapField("bing_grounding", this.bingGrounding,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepBingGroundingToolCall from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepBingGroundingToolCall if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunStepBingGroundingToolCall.
     */
    @Generated
    public static RunStepBingGroundingToolCall fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            Map<String, String> bingGrounding = null;
            String type = "bing_grounding";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("bing_grounding".equals(fieldName)) {
                    bingGrounding = reader.readMap(reader1 -> reader1.getString());
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            RunStepBingGroundingToolCall deserializedRunStepBingGroundingToolCall
                = new RunStepBingGroundingToolCall(id, bingGrounding);
            deserializedRunStepBingGroundingToolCall.type = type;
            return deserializedRunStepBingGroundingToolCall;
        });
    }
}
