// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A representation of a log output emitted by a code interpreter tool in response to a tool call by the model.
 */
@Immutable
public final class RunStepCodeInterpreterLogOutput extends RunStepCodeInterpreterToolCallOutput {

    /*
     * The object type.
     */
    @Generated
    private String type = "logs";

    /*
     * The serialized log output emitted by the code interpreter.
     */
    @Generated
    private final String logs;

    /**
     * Creates an instance of RunStepCodeInterpreterLogOutput class.
     *
     * @param logs the logs value to set.
     */
    @Generated
    private RunStepCodeInterpreterLogOutput(String logs) {
        this.logs = logs;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the logs property: The serialized log output emitted by the code interpreter.
     *
     * @return the logs value.
     */
    @Generated
    public String getLogs() {
        return this.logs;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("logs", this.logs);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepCodeInterpreterLogOutput from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepCodeInterpreterLogOutput if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunStepCodeInterpreterLogOutput.
     */
    @Generated
    public static RunStepCodeInterpreterLogOutput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String logs = null;
            String type = "logs";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("logs".equals(fieldName)) {
                    logs = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            RunStepCodeInterpreterLogOutput deserializedRunStepCodeInterpreterLogOutput
                = new RunStepCodeInterpreterLogOutput(logs);
            deserializedRunStepCodeInterpreterLogOutput.type = type;
            return deserializedRunStepCodeInterpreterLogOutput;
        });
    }
}
