// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A record of a call to a code interpreter tool, issued by the model in evaluation of a defined tool, that
 * represents inputs and outputs consumed and emitted by the code interpreter.
 */
@Immutable
public final class RunStepCodeInterpreterToolCall extends RunStepToolCall {

    /*
     * The object type.
     */
    @Generated
    private String type = "code_interpreter";

    /*
     * The details of the tool call to the code interpreter tool.
     */
    @Generated
    private final RunStepCodeInterpreterToolCallDetails codeInterpreter;

    /**
     * Creates an instance of RunStepCodeInterpreterToolCall class.
     *
     * @param id the id value to set.
     * @param codeInterpreter the codeInterpreter value to set.
     */
    @Generated
    private RunStepCodeInterpreterToolCall(String id, RunStepCodeInterpreterToolCallDetails codeInterpreter) {
        super(id);
        this.codeInterpreter = codeInterpreter;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the codeInterpreter property: The details of the tool call to the code interpreter tool.
     *
     * @return the codeInterpreter value.
     */
    @Generated
    public RunStepCodeInterpreterToolCallDetails getCodeInterpreter() {
        return this.codeInterpreter;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeJsonField("code_interpreter", this.codeInterpreter);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepCodeInterpreterToolCall from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepCodeInterpreterToolCall if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunStepCodeInterpreterToolCall.
     */
    @Generated
    public static RunStepCodeInterpreterToolCall fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            RunStepCodeInterpreterToolCallDetails codeInterpreter = null;
            String type = "code_interpreter";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("code_interpreter".equals(fieldName)) {
                    codeInterpreter = RunStepCodeInterpreterToolCallDetails.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            RunStepCodeInterpreterToolCall deserializedRunStepCodeInterpreterToolCall
                = new RunStepCodeInterpreterToolCall(id, codeInterpreter);
            deserializedRunStepCodeInterpreterToolCall.type = type;
            return deserializedRunStepCodeInterpreterToolCall;
        });
    }
}
