// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Represents the Code Interpreter tool call data in a streaming run step's tool calls.
 */
@Immutable
public final class RunStepDeltaCodeInterpreterDetailItemObject
    implements JsonSerializable<RunStepDeltaCodeInterpreterDetailItemObject> {

    /*
     * The input into the Code Interpreter tool call.
     */
    @Generated
    private String input;

    /*
     * The outputs from the Code Interpreter tool call. Code Interpreter can output one or more
     * items, including text (`logs`) or images (`image`). Each of these are represented by a
     * different object type.
     */
    @Generated
    private List<RunStepDeltaCodeInterpreterOutput> outputs;

    /**
     * Creates an instance of RunStepDeltaCodeInterpreterDetailItemObject class.
     */
    @Generated
    private RunStepDeltaCodeInterpreterDetailItemObject() {
    }

    /**
     * Get the input property: The input into the Code Interpreter tool call.
     *
     * @return the input value.
     */
    @Generated
    public String getInput() {
        return this.input;
    }

    /**
     * Get the outputs property: The outputs from the Code Interpreter tool call. Code Interpreter can output one or
     * more
     * items, including text (`logs`) or images (`image`). Each of these are represented by a
     * different object type.
     *
     * @return the outputs value.
     */
    @Generated
    public List<RunStepDeltaCodeInterpreterOutput> getOutputs() {
        return this.outputs;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("input", this.input);
        jsonWriter.writeArrayField("outputs", this.outputs, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepDeltaCodeInterpreterDetailItemObject from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepDeltaCodeInterpreterDetailItemObject if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RunStepDeltaCodeInterpreterDetailItemObject.
     */
    @Generated
    public static RunStepDeltaCodeInterpreterDetailItemObject fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RunStepDeltaCodeInterpreterDetailItemObject deserializedRunStepDeltaCodeInterpreterDetailItemObject
                = new RunStepDeltaCodeInterpreterDetailItemObject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("input".equals(fieldName)) {
                    deserializedRunStepDeltaCodeInterpreterDetailItemObject.input = reader.getString();
                } else if ("outputs".equals(fieldName)) {
                    List<RunStepDeltaCodeInterpreterOutput> outputs
                        = reader.readArray(reader1 -> RunStepDeltaCodeInterpreterOutput.fromJson(reader1));
                    deserializedRunStepDeltaCodeInterpreterDetailItemObject.outputs = outputs;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedRunStepDeltaCodeInterpreterDetailItemObject;
        });
    }
}
