// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the data for a streaming run step's Code Interpreter tool call image output.
 */
@Immutable
public final class RunStepDeltaCodeInterpreterImageOutputObject
    implements JsonSerializable<RunStepDeltaCodeInterpreterImageOutputObject> {

    /*
     * The file ID for the image.
     */
    @Generated
    private String fileId;

    /**
     * Creates an instance of RunStepDeltaCodeInterpreterImageOutputObject class.
     */
    @Generated
    private RunStepDeltaCodeInterpreterImageOutputObject() {
    }

    /**
     * Get the fileId property: The file ID for the image.
     *
     * @return the fileId value.
     */
    @Generated
    public String getFileId() {
        return this.fileId;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("file_id", this.fileId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepDeltaCodeInterpreterImageOutputObject from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepDeltaCodeInterpreterImageOutputObject if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RunStepDeltaCodeInterpreterImageOutputObject.
     */
    @Generated
    public static RunStepDeltaCodeInterpreterImageOutputObject fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RunStepDeltaCodeInterpreterImageOutputObject deserializedRunStepDeltaCodeInterpreterImageOutputObject
                = new RunStepDeltaCodeInterpreterImageOutputObject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_id".equals(fieldName)) {
                    deserializedRunStepDeltaCodeInterpreterImageOutputObject.fileId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedRunStepDeltaCodeInterpreterImageOutputObject;
        });
    }
}
