// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a log output as produced by the Code Interpreter tool and as represented in a streaming run step's delta
 * tool calls collection.
 */
@Immutable
public final class RunStepDeltaCodeInterpreterLogOutput extends RunStepDeltaCodeInterpreterOutput {

    /*
     * The type of the streaming run step tool call's Code Interpreter output.
     */
    @Generated
    private String type = "logs";

    /*
     * The text output from the Code Interpreter tool call.
     */
    @Generated
    private String logs;

    /**
     * Creates an instance of RunStepDeltaCodeInterpreterLogOutput class.
     *
     * @param index the index value to set.
     */
    @Generated
    private RunStepDeltaCodeInterpreterLogOutput(int index) {
        super(index);
    }

    /**
     * Get the type property: The type of the streaming run step tool call's Code Interpreter output.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the logs property: The text output from the Code Interpreter tool call.
     *
     * @return the logs value.
     */
    @Generated
    public String getLogs() {
        return this.logs;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", getIndex());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("logs", this.logs);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepDeltaCodeInterpreterLogOutput from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepDeltaCodeInterpreterLogOutput if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunStepDeltaCodeInterpreterLogOutput.
     */
    @Generated
    public static RunStepDeltaCodeInterpreterLogOutput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int index = 0;
            String type = "logs";
            String logs = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("logs".equals(fieldName)) {
                    logs = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            RunStepDeltaCodeInterpreterLogOutput deserializedRunStepDeltaCodeInterpreterLogOutput
                = new RunStepDeltaCodeInterpreterLogOutput(index);
            deserializedRunStepDeltaCodeInterpreterLogOutput.type = type;
            deserializedRunStepDeltaCodeInterpreterLogOutput.logs = logs;
            return deserializedRunStepDeltaCodeInterpreterLogOutput;
        });
    }
}
