// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a Code Interpreter tool call within a streaming run step's tool call details.
 */
@Immutable
public final class RunStepDeltaCodeInterpreterToolCall extends RunStepDeltaToolCall {

    /*
     * The type of the tool call detail item in a streaming run step's details.
     */
    @Generated
    private String type = "code_interpreter";

    /*
     * The Code Interpreter data for the tool call.
     */
    @Generated
    private RunStepDeltaCodeInterpreterDetailItemObject codeInterpreter;

    /**
     * Creates an instance of RunStepDeltaCodeInterpreterToolCall class.
     *
     * @param index the index value to set.
     * @param id the id value to set.
     */
    @Generated
    private RunStepDeltaCodeInterpreterToolCall(int index, String id) {
        super(index, id);
    }

    /**
     * Get the type property: The type of the tool call detail item in a streaming run step's details.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the codeInterpreter property: The Code Interpreter data for the tool call.
     *
     * @return the codeInterpreter value.
     */
    @Generated
    public RunStepDeltaCodeInterpreterDetailItemObject getCodeInterpreter() {
        return this.codeInterpreter;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", getIndex());
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("code_interpreter", this.codeInterpreter);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepDeltaCodeInterpreterToolCall from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepDeltaCodeInterpreterToolCall if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunStepDeltaCodeInterpreterToolCall.
     */
    @Generated
    public static RunStepDeltaCodeInterpreterToolCall fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int index = 0;
            String id = null;
            String type = "code_interpreter";
            RunStepDeltaCodeInterpreterDetailItemObject codeInterpreter = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                } else if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("code_interpreter".equals(fieldName)) {
                    codeInterpreter = RunStepDeltaCodeInterpreterDetailItemObject.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            RunStepDeltaCodeInterpreterToolCall deserializedRunStepDeltaCodeInterpreterToolCall
                = new RunStepDeltaCodeInterpreterToolCall(index, id);
            deserializedRunStepDeltaCodeInterpreterToolCall.type = type;
            deserializedRunStepDeltaCodeInterpreterToolCall.codeInterpreter = codeInterpreter;
            return deserializedRunStepDeltaCodeInterpreterToolCall;
        });
    }
}
