// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The abstract base representation of a single tool call within a streaming run step's delta tool call details.
 */
@Immutable
public class RunStepDeltaToolCall implements JsonSerializable<RunStepDeltaToolCall> {

    /*
     * The type of the tool call detail item in a streaming run step's details.
     */
    @Generated
    private String type = "RunStepDeltaToolCall";

    /*
     * The index of the tool call detail in the run step's tool_calls array.
     */
    @Generated
    private final int index;

    /*
     * The ID of the tool call, used when submitting outputs to the run.
     */
    @Generated
    private final String id;

    /**
     * Creates an instance of RunStepDeltaToolCall class.
     *
     * @param index the index value to set.
     * @param id the id value to set.
     */
    @Generated
    protected RunStepDeltaToolCall(int index, String id) {
        this.index = index;
        this.id = id;
    }

    /**
     * Get the type property: The type of the tool call detail item in a streaming run step's details.
     *
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * Get the index property: The index of the tool call detail in the run step's tool_calls array.
     *
     * @return the index value.
     */
    @Generated
    public int getIndex() {
        return this.index;
    }

    /**
     * Get the id property: The ID of the tool call, used when submitting outputs to the run.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.index);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepDeltaToolCall from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepDeltaToolCall if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunStepDeltaToolCall.
     */
    @Generated
    public static RunStepDeltaToolCall fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("function".equals(discriminatorValue)) {
                    return RunStepDeltaFunctionToolCall.fromJson(readerToUse.reset());
                } else if ("file_search".equals(discriminatorValue)) {
                    return RunStepDeltaFileSearchToolCall.fromJson(readerToUse.reset());
                } else if ("code_interpreter".equals(discriminatorValue)) {
                    return RunStepDeltaCodeInterpreterToolCall.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static RunStepDeltaToolCall fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int index = 0;
            String id = null;
            String type = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                } else if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            RunStepDeltaToolCall deserializedRunStepDeltaToolCall = new RunStepDeltaToolCall(index, id);
            deserializedRunStepDeltaToolCall.type = type;
            return deserializedRunStepDeltaToolCall;
        });
    }
}
