// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Represents an invocation of tool calls as part of a streaming run step.
 */
@Immutable
public final class RunStepDeltaToolCallObject extends RunStepDeltaDetail {

    /*
     * The object type for the run step detail object.
     */
    @Generated
    private String type = "tool_calls";

    /*
     * The collection of tool calls for the tool call detail item.
     */
    @Generated
    private List<RunStepDeltaToolCall> toolCalls;

    /**
     * Creates an instance of RunStepDeltaToolCallObject class.
     */
    @Generated
    private RunStepDeltaToolCallObject() {
    }

    /**
     * Get the type property: The object type for the run step detail object.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the toolCalls property: The collection of tool calls for the tool call detail item.
     *
     * @return the toolCalls value.
     */
    @Generated
    public List<RunStepDeltaToolCall> getToolCalls() {
        return this.toolCalls;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeArrayField("tool_calls", this.toolCalls, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepDeltaToolCallObject from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepDeltaToolCallObject if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RunStepDeltaToolCallObject.
     */
    @Generated
    public static RunStepDeltaToolCallObject fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RunStepDeltaToolCallObject deserializedRunStepDeltaToolCallObject = new RunStepDeltaToolCallObject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedRunStepDeltaToolCallObject.type = reader.getString();
                } else if ("tool_calls".equals(fieldName)) {
                    List<RunStepDeltaToolCall> toolCalls
                        = reader.readArray(reader1 -> RunStepDeltaToolCall.fromJson(reader1));
                    deserializedRunStepDeltaToolCallObject.toolCalls = toolCalls;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedRunStepDeltaToolCallObject;
        });
    }
}
