// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Possible error code values attributable to a failed run step.
 */
public final class RunStepErrorCode extends ExpandableStringEnum<RunStepErrorCode> {

    /**
     * Represents a server error.
     */
    @Generated
    public static final RunStepErrorCode SERVER_ERROR = fromString("server_error");

    /**
     * Represents an error indicating configured rate limits were exceeded.
     */
    @Generated
    public static final RunStepErrorCode RATE_LIMIT_EXCEEDED = fromString("rate_limit_exceeded");

    /**
     * Creates a new instance of RunStepErrorCode value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public RunStepErrorCode() {
    }

    /**
     * Creates or finds a RunStepErrorCode from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding RunStepErrorCode.
     */
    @Generated
    public static RunStepErrorCode fromString(String name) {
        return fromString(name, RunStepErrorCode.class);
    }

    /**
     * Gets known RunStepErrorCode values.
     *
     * @return known RunStepErrorCode values.
     */
    @Generated
    public static Collection<RunStepErrorCode> values() {
        return values(RunStepErrorCode.class);
    }
}
