// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A record of a call to a file search tool, issued by the model in evaluation of a defined tool, that represents
 * executed file search.
 */
@Immutable
public final class RunStepFileSearchToolCall extends RunStepToolCall {

    /*
     * The object type.
     */
    @Generated
    private String type = "file_search";

    /*
     * For now, this is always going to be an empty object.
     */
    @Generated
    private final RunStepFileSearchToolCallResults fileSearch;

    /**
     * Creates an instance of RunStepFileSearchToolCall class.
     *
     * @param id the id value to set.
     * @param fileSearch the fileSearch value to set.
     */
    @Generated
    private RunStepFileSearchToolCall(String id, RunStepFileSearchToolCallResults fileSearch) {
        super(id);
        this.fileSearch = fileSearch;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the fileSearch property: For now, this is always going to be an empty object.
     *
     * @return the fileSearch value.
     */
    @Generated
    public RunStepFileSearchToolCallResults getFileSearch() {
        return this.fileSearch;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeJsonField("file_search", this.fileSearch);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepFileSearchToolCall from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepFileSearchToolCall if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunStepFileSearchToolCall.
     */
    @Generated
    public static RunStepFileSearchToolCall fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            RunStepFileSearchToolCallResults fileSearch = null;
            String type = "file_search";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("file_search".equals(fieldName)) {
                    fileSearch = RunStepFileSearchToolCallResults.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            RunStepFileSearchToolCall deserializedRunStepFileSearchToolCall
                = new RunStepFileSearchToolCall(id, fileSearch);
            deserializedRunStepFileSearchToolCall.type = type;
            return deserializedRunStepFileSearchToolCall;
        });
    }
}
