// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * File search tool call result.
 */
@Immutable
public final class RunStepFileSearchToolCallResult implements JsonSerializable<RunStepFileSearchToolCallResult> {

    /*
     * The ID of the file that result was found in.
     */
    @Generated
    private final String fileId;

    /*
     * The name of the file that result was found in.
     */
    @Generated
    private final String fileName;

    /*
     * The score of the result. All values must be a floating point number between 0 and 1.
     */
    @Generated
    private final double score;

    /*
     * The content of the result that was found. The content is only included if requested via the include query
     * parameter.
     */
    @Generated
    private List<FileSearchToolCallContent> content;

    /**
     * Creates an instance of RunStepFileSearchToolCallResult class.
     *
     * @param fileId the fileId value to set.
     * @param fileName the fileName value to set.
     * @param score the score value to set.
     */
    @Generated
    private RunStepFileSearchToolCallResult(String fileId, String fileName, double score) {
        this.fileId = fileId;
        this.fileName = fileName;
        this.score = score;
    }

    /**
     * Get the fileId property: The ID of the file that result was found in.
     *
     * @return the fileId value.
     */
    @Generated
    public String getFileId() {
        return this.fileId;
    }

    /**
     * Get the fileName property: The name of the file that result was found in.
     *
     * @return the fileName value.
     */
    @Generated
    public String getFileName() {
        return this.fileName;
    }

    /**
     * Get the score property: The score of the result. All values must be a floating point number between 0 and 1.
     *
     * @return the score value.
     */
    @Generated
    public double getScore() {
        return this.score;
    }

    /**
     * Get the content property: The content of the result that was found. The content is only included if requested via
     * the include query parameter.
     *
     * @return the content value.
     */
    @Generated
    public List<FileSearchToolCallContent> getContent() {
        return this.content;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("file_id", this.fileId);
        jsonWriter.writeStringField("file_name", this.fileName);
        jsonWriter.writeDoubleField("score", this.score);
        jsonWriter.writeArrayField("content", this.content, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepFileSearchToolCallResult from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepFileSearchToolCallResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunStepFileSearchToolCallResult.
     */
    @Generated
    public static RunStepFileSearchToolCallResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String fileId = null;
            String fileName = null;
            double score = 0.0;
            List<FileSearchToolCallContent> content = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_id".equals(fieldName)) {
                    fileId = reader.getString();
                } else if ("file_name".equals(fieldName)) {
                    fileName = reader.getString();
                } else if ("score".equals(fieldName)) {
                    score = reader.getDouble();
                } else if ("content".equals(fieldName)) {
                    content = reader.readArray(reader1 -> FileSearchToolCallContent.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            RunStepFileSearchToolCallResult deserializedRunStepFileSearchToolCallResult
                = new RunStepFileSearchToolCallResult(fileId, fileName, score);
            deserializedRunStepFileSearchToolCallResult.content = content;
            return deserializedRunStepFileSearchToolCallResult;
        });
    }
}
