// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The results of the file search.
 */
@Immutable
public final class RunStepFileSearchToolCallResults implements JsonSerializable<RunStepFileSearchToolCallResults> {

    /*
     * Ranking options for file search.
     */
    @Generated
    private FileSearchRankingOptions rankingOptions;

    /*
     * The array of a file search results
     */
    @Generated
    private final List<RunStepFileSearchToolCallResult> results;

    /**
     * Creates an instance of RunStepFileSearchToolCallResults class.
     *
     * @param results the results value to set.
     */
    @Generated
    private RunStepFileSearchToolCallResults(List<RunStepFileSearchToolCallResult> results) {
        this.results = results;
    }

    /**
     * Get the rankingOptions property: Ranking options for file search.
     *
     * @return the rankingOptions value.
     */
    @Generated
    public FileSearchRankingOptions getRankingOptions() {
        return this.rankingOptions;
    }

    /**
     * Get the results property: The array of a file search results.
     *
     * @return the results value.
     */
    @Generated
    public List<RunStepFileSearchToolCallResult> getResults() {
        return this.results;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("results", this.results, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("ranking_options", this.rankingOptions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepFileSearchToolCallResults from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepFileSearchToolCallResults if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunStepFileSearchToolCallResults.
     */
    @Generated
    public static RunStepFileSearchToolCallResults fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<RunStepFileSearchToolCallResult> results = null;
            FileSearchRankingOptions rankingOptions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("results".equals(fieldName)) {
                    results = reader.readArray(reader1 -> RunStepFileSearchToolCallResult.fromJson(reader1));
                } else if ("ranking_options".equals(fieldName)) {
                    rankingOptions = FileSearchRankingOptions.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            RunStepFileSearchToolCallResults deserializedRunStepFileSearchToolCallResults
                = new RunStepFileSearchToolCallResults(results);
            deserializedRunStepFileSearchToolCallResults.rankingOptions = rankingOptions;
            return deserializedRunStepFileSearchToolCallResults;
        });
    }
}
