// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * A record of a call to a Microsoft Fabric tool, issued by the model in evaluation of a defined tool, that represents
 * executed Microsoft Fabric operations.
 */
@Immutable
public final class RunStepMicrosoftFabricToolCall extends RunStepToolCall {

    /*
     * The object type.
     */
    @Generated
    private String type = "fabric_dataagent";

    /*
     * Reserved for future use.
     */
    @Generated
    private final Map<String, String> microsoftFabric;

    /**
     * Creates an instance of RunStepMicrosoftFabricToolCall class.
     *
     * @param id the id value to set.
     * @param microsoftFabric the microsoftFabric value to set.
     */
    @Generated
    private RunStepMicrosoftFabricToolCall(String id, Map<String, String> microsoftFabric) {
        super(id);
        this.microsoftFabric = microsoftFabric;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the microsoftFabric property: Reserved for future use.
     *
     * @return the microsoftFabric value.
     */
    @Generated
    public Map<String, String> getMicrosoftFabric() {
        return this.microsoftFabric;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeMapField("fabric_dataagent", this.microsoftFabric,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepMicrosoftFabricToolCall from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepMicrosoftFabricToolCall if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunStepMicrosoftFabricToolCall.
     */
    @Generated
    public static RunStepMicrosoftFabricToolCall fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            Map<String, String> microsoftFabric = null;
            String type = "fabric_dataagent";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("fabric_dataagent".equals(fieldName)) {
                    microsoftFabric = reader.readMap(reader1 -> reader1.getString());
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            RunStepMicrosoftFabricToolCall deserializedRunStepMicrosoftFabricToolCall
                = new RunStepMicrosoftFabricToolCall(id, microsoftFabric);
            deserializedRunStepMicrosoftFabricToolCall.type = type;
            return deserializedRunStepMicrosoftFabricToolCall;
        });
    }
}
