// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * A record of a call to an OpenAPI tool, issued by the model in evaluation of a defined tool, that represents
 * executed OpenAPI operations.
 */
@Immutable
public final class RunStepOpenApiToolCall extends RunStepToolCall {

    /*
     * The object type.
     */
    @Generated
    private String type = "openapi";

    /*
     * Reserved for future use.
     */
    @Generated
    private final Map<String, String> openApi;

    /**
     * Creates an instance of RunStepOpenApiToolCall class.
     *
     * @param id the id value to set.
     * @param openApi the openApi value to set.
     */
    @Generated
    private RunStepOpenApiToolCall(String id, Map<String, String> openApi) {
        super(id);
        this.openApi = openApi;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the openApi property: Reserved for future use.
     *
     * @return the openApi value.
     */
    @Generated
    public Map<String, String> getOpenApi() {
        return this.openApi;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeMapField("openapi", this.openApi, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepOpenApiToolCall from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepOpenApiToolCall if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunStepOpenApiToolCall.
     */
    @Generated
    public static RunStepOpenApiToolCall fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            Map<String, String> openApi = null;
            String type = "openapi";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("openapi".equals(fieldName)) {
                    openApi = reader.readMap(reader1 -> reader1.getString());
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            RunStepOpenApiToolCall deserializedRunStepOpenApiToolCall = new RunStepOpenApiToolCall(id, openApi);
            deserializedRunStepOpenApiToolCall.type = type;
            return deserializedRunStepOpenApiToolCall;
        });
    }
}
