// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * A record of a call to a SharePoint tool, issued by the model in evaluation of a defined tool, that represents
 * executed SharePoint actions.
 */
@Immutable
public final class RunStepSharepointToolCall extends RunStepToolCall {

    /*
     * The object type.
     */
    @Generated
    private String type = "sharepoint_grounding";

    /*
     * Reserved for future use.
     */
    @Generated
    private final Map<String, String> sharePoint;

    /**
     * Creates an instance of RunStepSharepointToolCall class.
     *
     * @param id the id value to set.
     * @param sharePoint the sharePoint value to set.
     */
    @Generated
    private RunStepSharepointToolCall(String id, Map<String, String> sharePoint) {
        super(id);
        this.sharePoint = sharePoint;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the sharePoint property: Reserved for future use.
     *
     * @return the sharePoint value.
     */
    @Generated
    public Map<String, String> getSharePoint() {
        return this.sharePoint;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeMapField("sharepoint_grounding", this.sharePoint,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepSharepointToolCall from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepSharepointToolCall if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunStepSharepointToolCall.
     */
    @Generated
    public static RunStepSharepointToolCall fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            Map<String, String> sharePoint = null;
            String type = "sharepoint_grounding";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("sharepoint_grounding".equals(fieldName)) {
                    sharePoint = reader.readMap(reader1 -> reader1.getString());
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            RunStepSharepointToolCall deserializedRunStepSharepointToolCall
                = new RunStepSharepointToolCall(id, sharePoint);
            deserializedRunStepSharepointToolCall.type = type;
            return deserializedRunStepSharepointToolCall;
        });
    }
}
