// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Possible values for the status of a run step.
 */
public final class RunStepStatus extends ExpandableStringEnum<RunStepStatus> {

    /**
     * Represents a run step still in progress.
     */
    @Generated
    public static final RunStepStatus IN_PROGRESS = fromString("in_progress");

    /**
     * Represents a run step that was cancelled.
     */
    @Generated
    public static final RunStepStatus CANCELLED = fromString("cancelled");

    /**
     * Represents a run step that failed.
     */
    @Generated
    public static final RunStepStatus FAILED = fromString("failed");

    /**
     * Represents a run step that successfully completed.
     */
    @Generated
    public static final RunStepStatus COMPLETED = fromString("completed");

    /**
     * Represents a run step that expired before otherwise finishing.
     */
    @Generated
    public static final RunStepStatus EXPIRED = fromString("expired");

    /**
     * Creates a new instance of RunStepStatus value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public RunStepStatus() {
    }

    /**
     * Creates or finds a RunStepStatus from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding RunStepStatus.
     */
    @Generated
    public static RunStepStatus fromString(String name) {
        return fromString(name, RunStepStatus.class);
    }

    /**
     * Gets known RunStepStatus values.
     *
     * @return known RunStepStatus values.
     */
    @Generated
    public static Collection<RunStepStatus> values() {
        return values(RunStepStatus.class);
    }
}
