// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Run step operation related streaming events.
 */
public final class RunStepStreamEvent extends ExpandableStringEnum<RunStepStreamEvent> {

    /**
     * Event sent when a new thread run step is created. The data of this event is of type RunStep.
     */
    @Generated
    public static final RunStepStreamEvent THREAD_RUN_STEP_CREATED = fromString("thread.run.step.created");

    /**
     * Event sent when a run step moves to `in_progress` status. The data of this event is of type RunStep.
     */
    @Generated
    public static final RunStepStreamEvent THREAD_RUN_STEP_IN_PROGRESS = fromString("thread.run.step.in_progress");

    /**
     * Event sent when a run step is being streamed. The data of this event is of type RunStepDeltaChunk.
     */
    @Generated
    public static final RunStepStreamEvent THREAD_RUN_STEP_DELTA = fromString("thread.run.step.delta");

    /**
     * Event sent when a run step is completed. The data of this event is of type RunStep.
     */
    @Generated
    public static final RunStepStreamEvent THREAD_RUN_STEP_COMPLETED = fromString("thread.run.step.completed");

    /**
     * Event sent when a run step fails. The data of this event is of type RunStep.
     */
    @Generated
    public static final RunStepStreamEvent THREAD_RUN_STEP_FAILED = fromString("thread.run.step.failed");

    /**
     * Event sent when a run step is cancelled. The data of this event is of type RunStep.
     */
    @Generated
    public static final RunStepStreamEvent THREAD_RUN_STEP_CANCELLED = fromString("thread.run.step.cancelled");

    /**
     * Event sent when a run step is expired. The data of this event is of type RunStep.
     */
    @Generated
    public static final RunStepStreamEvent THREAD_RUN_STEP_EXPIRED = fromString("thread.run.step.expired");

    /**
     * Creates a new instance of RunStepStreamEvent value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public RunStepStreamEvent() {
    }

    /**
     * Creates or finds a RunStepStreamEvent from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding RunStepStreamEvent.
     */
    @Generated
    public static RunStepStreamEvent fromString(String name) {
        return fromString(name, RunStepStreamEvent.class);
    }

    /**
     * Gets known RunStepStreamEvent values.
     *
     * @return known RunStepStreamEvent values.
     */
    @Generated
    public static Collection<RunStepStreamEvent> values() {
        return values(RunStepStreamEvent.class);
    }
}
