// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The detailed information associated with a run step calling tools.
 */
@Immutable
public final class RunStepToolCallDetails extends RunStepDetails {

    /*
     * The object type.
     */
    @Generated
    private RunStepType type = RunStepType.TOOL_CALLS;

    /*
     * A list of tool call details for this run step.
     */
    @Generated
    private final List<RunStepToolCall> toolCalls;

    /**
     * Creates an instance of RunStepToolCallDetails class.
     *
     * @param toolCalls the toolCalls value to set.
     */
    @Generated
    private RunStepToolCallDetails(List<RunStepToolCall> toolCalls) {
        this.toolCalls = toolCalls;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public RunStepType getType() {
        return this.type;
    }

    /**
     * Get the toolCalls property: A list of tool call details for this run step.
     *
     * @return the toolCalls value.
     */
    @Generated
    public List<RunStepToolCall> getToolCalls() {
        return this.toolCalls;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tool_calls", this.toolCalls, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunStepToolCallDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunStepToolCallDetails if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunStepToolCallDetails.
     */
    @Generated
    public static RunStepToolCallDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<RunStepToolCall> toolCalls = null;
            RunStepType type = RunStepType.TOOL_CALLS;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tool_calls".equals(fieldName)) {
                    toolCalls = reader.readArray(reader1 -> RunStepToolCall.fromJson(reader1));
                } else if ("type".equals(fieldName)) {
                    type = RunStepType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            RunStepToolCallDetails deserializedRunStepToolCallDetails = new RunStepToolCallDetails(toolCalls);
            deserializedRunStepToolCallDetails.type = type;
            return deserializedRunStepToolCallDetails;
        });
    }
}
