// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The possible types of run steps.
 */
public final class RunStepType extends ExpandableStringEnum<RunStepType> {

    /**
     * Represents a run step to create a message.
     */
    @Generated
    public static final RunStepType MESSAGE_CREATION = fromString("message_creation");

    /**
     * Represents a run step that calls tools.
     */
    @Generated
    public static final RunStepType TOOL_CALLS = fromString("tool_calls");

    /**
     * Creates a new instance of RunStepType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public RunStepType() {
    }

    /**
     * Creates or finds a RunStepType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding RunStepType.
     */
    @Generated
    public static RunStepType fromString(String name) {
        return fromString(name, RunStepType.class);
    }

    /**
     * Gets known RunStepType values.
     *
     * @return known RunStepType values.
     */
    @Generated
    public static Collection<RunStepType> values() {
        return values(RunStepType.class);
    }
}
