// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Run operation related streaming events.
 */
public final class RunStreamEvent extends ExpandableStringEnum<RunStreamEvent> {

    /**
     * Event sent when a new run is created. The data of this event is of type ThreadRun.
     */
    @Generated
    public static final RunStreamEvent THREAD_RUN_CREATED = fromString("thread.run.created");

    /**
     * Event sent when a run moves to `queued` status. The data of this event is of type ThreadRun.
     */
    @Generated
    public static final RunStreamEvent THREAD_RUN_QUEUED = fromString("thread.run.queued");

    /**
     * Event sent when a run moves to `in_progress` status. The data of this event is of type ThreadRun.
     */
    @Generated
    public static final RunStreamEvent THREAD_RUN_IN_PROGRESS = fromString("thread.run.in_progress");

    /**
     * Event sent when a run moves to `requires_action` status. The data of this event is of type ThreadRun.
     */
    @Generated
    public static final RunStreamEvent THREAD_RUN_REQUIRES_ACTION = fromString("thread.run.requires_action");

    /**
     * Event sent when a run is completed. The data of this event is of type ThreadRun.
     */
    @Generated
    public static final RunStreamEvent THREAD_RUN_COMPLETED = fromString("thread.run.completed");

    /**
     * Event sent when a run ends incomplete. The data of this event is of type ThreadRun.
     */
    @Generated
    public static final RunStreamEvent THREAD_RUN_INCOMPLETE = fromString("thread.run.incomplete");

    /**
     * Event sent when a run fails. The data of this event is of type ThreadRun.
     */
    @Generated
    public static final RunStreamEvent THREAD_RUN_FAILED = fromString("thread.run.failed");

    /**
     * Event sent when a run moves to `cancelling` status. The data of this event is of type ThreadRun.
     */
    @Generated
    public static final RunStreamEvent THREAD_RUN_CANCELLING = fromString("thread.run.cancelling");

    /**
     * Event sent when a run is cancelled. The data of this event is of type ThreadRun.
     */
    @Generated
    public static final RunStreamEvent THREAD_RUN_CANCELLED = fromString("thread.run.cancelled");

    /**
     * Event sent when a run is expired. The data of this event is of type ThreadRun.
     */
    @Generated
    public static final RunStreamEvent THREAD_RUN_EXPIRED = fromString("thread.run.expired");

    /**
     * Creates a new instance of RunStreamEvent value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public RunStreamEvent() {
    }

    /**
     * Creates or finds a RunStreamEvent from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding RunStreamEvent.
     */
    @Generated
    public static RunStreamEvent fromString(String name) {
        return fromString(name, RunStreamEvent.class);
    }

    /**
     * Gets known RunStreamEvent values.
     *
     * @return known RunStreamEvent values.
     */
    @Generated
    public static Collection<RunStreamEvent> values() {
        return values(RunStreamEvent.class);
    }
}
