// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The input definition information for a sharepoint tool as used to configure an agent.
 */
@Immutable
public final class SharepointToolDefinition extends ToolDefinition {

    /*
     * The object type.
     */
    @Generated
    private String type = "sharepoint_grounding";

    /*
     * The sharepoint grounding tool parameters.
     */
    @Generated
    private final SharepointGroundingToolParameters sharepointGrounding;

    /**
     * Creates an instance of SharepointToolDefinition class.
     *
     * @param sharepointGrounding the sharepointGrounding value to set.
     */
    @Generated
    public SharepointToolDefinition(SharepointGroundingToolParameters sharepointGrounding) {
        this.sharepointGrounding = sharepointGrounding;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the sharepointGrounding property: The sharepoint grounding tool parameters.
     *
     * @return the sharepointGrounding value.
     */
    @Generated
    public SharepointGroundingToolParameters getSharepointGrounding() {
        return this.sharepointGrounding;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sharepoint_grounding", this.sharepointGrounding);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SharepointToolDefinition from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of SharepointToolDefinition if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SharepointToolDefinition.
     */
    @Generated
    public static SharepointToolDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SharepointGroundingToolParameters sharepointGrounding = null;
            String type = "sharepoint_grounding";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sharepoint_grounding".equals(fieldName)) {
                    sharepointGrounding = SharepointGroundingToolParameters.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            SharepointToolDefinition deserializedSharepointToolDefinition
                = new SharepointToolDefinition(sharepointGrounding);
            deserializedSharepointToolDefinition.type = type;
            return deserializedSharepointToolDefinition;
        });
    }
}
