// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The details for required tool calls that must be submitted for an agent thread run to continue.
 */
@Immutable
public final class SubmitToolOutputsAction extends RequiredAction {

    /*
     * The object type.
     */
    @Generated
    private String type = "submit_tool_outputs";

    /*
     * The details describing tools that should be called to submit tool outputs.
     */
    @Generated
    private final SubmitToolOutputsDetails submitToolOutputs;

    /**
     * Creates an instance of SubmitToolOutputsAction class.
     *
     * @param submitToolOutputs the submitToolOutputs value to set.
     */
    @Generated
    private SubmitToolOutputsAction(SubmitToolOutputsDetails submitToolOutputs) {
        this.submitToolOutputs = submitToolOutputs;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the submitToolOutputs property: The details describing tools that should be called to submit tool outputs.
     *
     * @return the submitToolOutputs value.
     */
    @Generated
    public SubmitToolOutputsDetails getSubmitToolOutputs() {
        return this.submitToolOutputs;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("submit_tool_outputs", this.submitToolOutputs);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SubmitToolOutputsAction from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of SubmitToolOutputsAction if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SubmitToolOutputsAction.
     */
    @Generated
    public static SubmitToolOutputsAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SubmitToolOutputsDetails submitToolOutputs = null;
            String type = "submit_tool_outputs";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("submit_tool_outputs".equals(fieldName)) {
                    submitToolOutputs = SubmitToolOutputsDetails.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            SubmitToolOutputsAction deserializedSubmitToolOutputsAction
                = new SubmitToolOutputsAction(submitToolOutputs);
            deserializedSubmitToolOutputsAction.type = type;
            return deserializedSubmitToolOutputsAction;
        });
    }
}
