// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The details describing tools that should be called to submit tool outputs.
 */
@Immutable
public final class SubmitToolOutputsDetails implements JsonSerializable<SubmitToolOutputsDetails> {

    /*
     * The list of tool calls that must be resolved for the agent thread run to continue.
     */
    @Generated
    private final List<RequiredToolCall> toolCalls;

    /**
     * Creates an instance of SubmitToolOutputsDetails class.
     *
     * @param toolCalls the toolCalls value to set.
     */
    @Generated
    private SubmitToolOutputsDetails(List<RequiredToolCall> toolCalls) {
        this.toolCalls = toolCalls;
    }

    /**
     * Get the toolCalls property: The list of tool calls that must be resolved for the agent thread run to continue.
     *
     * @return the toolCalls value.
     */
    @Generated
    public List<RequiredToolCall> getToolCalls() {
        return this.toolCalls;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tool_calls", this.toolCalls, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SubmitToolOutputsDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of SubmitToolOutputsDetails if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SubmitToolOutputsDetails.
     */
    @Generated
    public static SubmitToolOutputsDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<RequiredToolCall> toolCalls = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tool_calls".equals(fieldName)) {
                    toolCalls = reader.readArray(reader1 -> RequiredToolCall.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            return new SubmitToolOutputsDetails(toolCalls);
        });
    }
}
