// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;

/**
 * A single, existing message within an agent thread.
 */
@Immutable
public final class ThreadMessage implements JsonSerializable<ThreadMessage> {

    /*
     * The identifier, which can be referenced in API endpoints.
     */
    @Generated
    private final String id;

    /*
     * The object type, which is always 'thread.message'.
     */
    @Generated
    private final String object = "thread.message";

    /*
     * The Unix timestamp, in seconds, representing when this object was created.
     */
    @Generated
    private final long createdAt;

    /*
     * The ID of the thread that this message belongs to.
     */
    @Generated
    private final String threadId;

    /*
     * The status of the message.
     */
    @Generated
    private final MessageStatus status;

    /*
     * On an incomplete message, details about why the message is incomplete.
     */
    @Generated
    private final MessageIncompleteDetails incompleteDetails;

    /*
     * The Unix timestamp (in seconds) for when the message was completed.
     */
    @Generated
    private final Long completedAt;

    /*
     * The Unix timestamp (in seconds) for when the message was marked as incomplete.
     */
    @Generated
    private final Long incompleteAt;

    /*
     * The role associated with the agent thread message.
     */
    @Generated
    private final MessageRole role;

    /*
     * The list of content items associated with the agent thread message.
     */
    @Generated
    private final List<MessageContent> content;

    /*
     * If applicable, the ID of the agent that authored this message.
     */
    @Generated
    private final String assistantId;

    /*
     * If applicable, the ID of the run associated with the authoring of this message.
     */
    @Generated
    private final String runId;

    /*
     * A list of files attached to the message, and the tools they were added to.
     */
    @Generated
    private final List<MessageAttachment> attachments;

    /*
     * A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information
     * about that object in a structured format. Keys may be up to 64 characters in length and values may be up to 512
     * characters in length.
     */
    @Generated
    private final Map<String, String> metadata;

    /**
     * Creates an instance of ThreadMessage class.
     *
     * @param id the id value to set.
     * @param createdAt the createdAt value to set.
     * @param threadId the threadId value to set.
     * @param status the status value to set.
     * @param incompleteDetails the incompleteDetails value to set.
     * @param completedAt the completedAt value to set.
     * @param incompleteAt the incompleteAt value to set.
     * @param role the role value to set.
     * @param content the content value to set.
     * @param assistantId the assistantId value to set.
     * @param runId the runId value to set.
     * @param attachments the attachments value to set.
     * @param metadata the metadata value to set.
     */
    @Generated
    private ThreadMessage(String id, OffsetDateTime createdAt, String threadId, MessageStatus status,
        MessageIncompleteDetails incompleteDetails, OffsetDateTime completedAt, OffsetDateTime incompleteAt,
        MessageRole role, List<MessageContent> content, String assistantId, String runId,
        List<MessageAttachment> attachments, Map<String, String> metadata) {
        this.id = id;
        if (createdAt == null) {
            this.createdAt = 0L;
        } else {
            this.createdAt = createdAt.toEpochSecond();
        }
        this.threadId = threadId;
        this.status = status;
        this.incompleteDetails = incompleteDetails;
        if (completedAt == null) {
            this.completedAt = null;
        } else {
            this.completedAt = completedAt.toEpochSecond();
        }
        if (incompleteAt == null) {
            this.incompleteAt = null;
        } else {
            this.incompleteAt = incompleteAt.toEpochSecond();
        }
        this.role = role;
        this.content = content;
        this.assistantId = assistantId;
        this.runId = runId;
        this.attachments = attachments;
        this.metadata = metadata;
    }

    /**
     * Get the id property: The identifier, which can be referenced in API endpoints.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the object property: The object type, which is always 'thread.message'.
     *
     * @return the object value.
     */
    @Generated
    public String getObject() {
        return this.object;
    }

    /**
     * Get the createdAt property: The Unix timestamp, in seconds, representing when this object was created.
     *
     * @return the createdAt value.
     */
    @Generated
    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    /**
     * Get the threadId property: The ID of the thread that this message belongs to.
     *
     * @return the threadId value.
     */
    @Generated
    public String getThreadId() {
        return this.threadId;
    }

    /**
     * Get the status property: The status of the message.
     *
     * @return the status value.
     */
    @Generated
    public MessageStatus getStatus() {
        return this.status;
    }

    /**
     * Get the incompleteDetails property: On an incomplete message, details about why the message is incomplete.
     *
     * @return the incompleteDetails value.
     */
    @Generated
    public MessageIncompleteDetails getIncompleteDetails() {
        return this.incompleteDetails;
    }

    /**
     * Get the completedAt property: The Unix timestamp (in seconds) for when the message was completed.
     *
     * @return the completedAt value.
     */
    @Generated
    public OffsetDateTime getCompletedAt() {
        if (this.completedAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.completedAt), ZoneOffset.UTC);
    }

    /**
     * Get the incompleteAt property: The Unix timestamp (in seconds) for when the message was marked as incomplete.
     *
     * @return the incompleteAt value.
     */
    @Generated
    public OffsetDateTime getIncompleteAt() {
        if (this.incompleteAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.incompleteAt), ZoneOffset.UTC);
    }

    /**
     * Get the role property: The role associated with the agent thread message.
     *
     * @return the role value.
     */
    @Generated
    public MessageRole getRole() {
        return this.role;
    }

    /**
     * Get the content property: The list of content items associated with the agent thread message.
     *
     * @return the content value.
     */
    @Generated
    public List<MessageContent> getContent() {
        return this.content;
    }

    /**
     * Get the assistantId property: If applicable, the ID of the agent that authored this message.
     *
     * @return the assistantId value.
     */
    @Generated
    public String getAssistantId() {
        return this.assistantId;
    }

    /**
     * Get the runId property: If applicable, the ID of the run associated with the authoring of this message.
     *
     * @return the runId value.
     */
    @Generated
    public String getRunId() {
        return this.runId;
    }

    /**
     * Get the attachments property: A list of files attached to the message, and the tools they were added to.
     *
     * @return the attachments value.
     */
    @Generated
    public List<MessageAttachment> getAttachments() {
        return this.attachments;
    }

    /**
     * Get the metadata property: A set of up to 16 key/value pairs that can be attached to an object, used for storing
     * additional information about that object in a structured format. Keys may be up to 64 characters in length and
     * values may be up to 512 characters in length.
     *
     * @return the metadata value.
     */
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeStringField("thread_id", this.threadId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("incomplete_details", this.incompleteDetails);
        jsonWriter.writeNumberField("completed_at", this.completedAt);
        jsonWriter.writeNumberField("incomplete_at", this.incompleteAt);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeArrayField("content", this.content, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("assistant_id", this.assistantId);
        jsonWriter.writeStringField("run_id", this.runId);
        jsonWriter.writeArrayField("attachments", this.attachments, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ThreadMessage from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ThreadMessage if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ThreadMessage.
     */
    @Generated
    public static ThreadMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            String threadId = null;
            MessageStatus status = null;
            MessageIncompleteDetails incompleteDetails = null;
            OffsetDateTime completedAt = null;
            OffsetDateTime incompleteAt = null;
            MessageRole role = null;
            List<MessageContent> content = null;
            String assistantId = null;
            String runId = null;
            List<MessageAttachment> attachments = null;
            Map<String, String> metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                } else if ("thread_id".equals(fieldName)) {
                    threadId = reader.getString();
                } else if ("status".equals(fieldName)) {
                    status = MessageStatus.fromString(reader.getString());
                } else if ("incomplete_details".equals(fieldName)) {
                    incompleteDetails = MessageIncompleteDetails.fromJson(reader);
                } else if ("completed_at".equals(fieldName)) {
                    Long completedAtHolder = reader.getNullable(JsonReader::getLong);
                    if (completedAtHolder != null) {
                        completedAt
                            = OffsetDateTime.ofInstant(Instant.ofEpochSecond(completedAtHolder), ZoneOffset.UTC);
                    }
                } else if ("incomplete_at".equals(fieldName)) {
                    Long incompleteAtHolder = reader.getNullable(JsonReader::getLong);
                    if (incompleteAtHolder != null) {
                        incompleteAt
                            = OffsetDateTime.ofInstant(Instant.ofEpochSecond(incompleteAtHolder), ZoneOffset.UTC);
                    }
                } else if ("role".equals(fieldName)) {
                    role = MessageRole.fromString(reader.getString());
                } else if ("content".equals(fieldName)) {
                    content = reader.readArray(reader1 -> MessageContent.fromJson(reader1));
                } else if ("assistant_id".equals(fieldName)) {
                    assistantId = reader.getString();
                } else if ("run_id".equals(fieldName)) {
                    runId = reader.getString();
                } else if ("attachments".equals(fieldName)) {
                    attachments = reader.readArray(reader1 -> MessageAttachment.fromJson(reader1));
                } else if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return new ThreadMessage(id, createdAt, threadId, status, incompleteDetails, completedAt, incompleteAt,
                role, content, assistantId, runId, attachments, metadata);
        });
    }
}
