// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * A single message within an agent thread,
 * as provided during that thread's creation for its initial state.
 */
@Fluent
public final class ThreadMessageOptions implements JsonSerializable<ThreadMessageOptions> {

    /*
     * The role of the entity that is creating the message. Allowed values include:
     * `user`, which indicates the message is sent by an actual user (and should be
     * used in most cases to represent user-generated messages), and `assistant`,
     * which indicates the message is generated by the agent (use this value to insert
     * messages from the agent into the conversation).
     */
    @Generated
    private final MessageRole role;

    /*
     * The content of the initial message. This may be a basic string (if you only
     * need text) or an array of typed content blocks (for example, text, image_file,
     * image_url, and so on).
     */
    @Generated
    private final BinaryData content;

    /*
     * A list of files attached to the message, and the tools they should be added to.
     */
    @Generated
    private List<MessageAttachment> attachments;

    /*
     * A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information
     * about that object in a structured format. Keys may be up to 64 characters in length and values may be up to 512
     * characters in length.
     */
    @Generated
    private Map<String, String> metadata;

    /**
     * Creates an instance of ThreadMessageOptions class.
     *
     * @param role the role value to set.
     * @param content the content value to set.
     */
    @Generated
    public ThreadMessageOptions(MessageRole role, BinaryData content) {
        this.role = role;
        this.content = content;
    }

    /**
     * Get the role property: The role of the entity that is creating the message. Allowed values include:
     * `user`, which indicates the message is sent by an actual user (and should be
     * used in most cases to represent user-generated messages), and `assistant`,
     * which indicates the message is generated by the agent (use this value to insert
     * messages from the agent into the conversation).
     *
     * @return the role value.
     */
    @Generated
    public MessageRole getRole() {
        return this.role;
    }

    /**
     * Get the content property: The content of the initial message. This may be a basic string (if you only
     * need text) or an array of typed content blocks (for example, text, image_file,
     * image_url, and so on).
     *
     * @return the content value.
     */
    @Generated
    public BinaryData getContent() {
        return this.content;
    }

    /**
     * Get the attachments property: A list of files attached to the message, and the tools they should be added to.
     *
     * @return the attachments value.
     */
    @Generated
    public List<MessageAttachment> getAttachments() {
        return this.attachments;
    }

    /**
     * Set the attachments property: A list of files attached to the message, and the tools they should be added to.
     *
     * @param attachments the attachments value to set.
     * @return the ThreadMessageOptions object itself.
     */
    @Generated
    public ThreadMessageOptions setAttachments(List<MessageAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    /**
     * Get the metadata property: A set of up to 16 key/value pairs that can be attached to an object, used for storing
     * additional information about that object in a structured format. Keys may be up to 64 characters in length and
     * values may be up to 512 characters in length.
     *
     * @return the metadata value.
     */
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: A set of up to 16 key/value pairs that can be attached to an object, used for storing
     * additional information about that object in a structured format. Keys may be up to 64 characters in length and
     * values may be up to 512 characters in length.
     *
     * @param metadata the metadata value to set.
     * @return the ThreadMessageOptions object itself.
     */
    @Generated
    public ThreadMessageOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeFieldName("content");
        this.content.writeTo(jsonWriter);
        jsonWriter.writeArrayField("attachments", this.attachments, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ThreadMessageOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ThreadMessageOptions if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ThreadMessageOptions.
     */
    @Generated
    public static ThreadMessageOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MessageRole role = null;
            BinaryData content = null;
            List<MessageAttachment> attachments = null;
            Map<String, String> metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("role".equals(fieldName)) {
                    role = MessageRole.fromString(reader.getString());
                } else if ("content".equals(fieldName)) {
                    content = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("attachments".equals(fieldName)) {
                    attachments = reader.readArray(reader1 -> MessageAttachment.fromJson(reader1));
                } else if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ThreadMessageOptions deserializedThreadMessageOptions = new ThreadMessageOptions(role, content);
            deserializedThreadMessageOptions.attachments = attachments;
            deserializedThreadMessageOptions.metadata = metadata;
            return deserializedThreadMessageOptions;
        });
    }
}
