// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;

/**
 * Data representing a single evaluation run of an agent thread.
 */
@Immutable
public final class ThreadRun implements JsonSerializable<ThreadRun> {

    /*
     * The identifier, which can be referenced in API endpoints.
     */
    @Generated
    private final String id;

    /*
     * The object type, which is always 'thread.run'.
     */
    @Generated
    private final String object = "thread.run";

    /*
     * The ID of the thread associated with this run.
     */
    @Generated
    private final String threadId;

    /*
     * The ID of the agent associated with the thread this run was performed against.
     */
    @Generated
    private final String assistantId;

    /*
     * The status of the agent thread run.
     */
    @Generated
    private final RunStatus status;

    /*
     * The details of the action required for the agent thread run to continue.
     */
    @Generated
    private RequiredAction requiredAction;

    /*
     * The last error, if any, encountered by this agent thread run.
     */
    @Generated
    private final RunError lastError;

    /*
     * The ID of the model to use.
     */
    @Generated
    private final String model;

    /*
     * The overridden system instructions used for this agent thread run.
     */
    @Generated
    private final String instructions;

    /*
     * The overridden enabled tools used for this agent thread run.
     */
    @Generated
    private final List<ToolDefinition> tools;

    /*
     * The Unix timestamp, in seconds, representing when this object was created.
     */
    @Generated
    private final long createdAt;

    /*
     * The Unix timestamp, in seconds, representing when this item expires.
     */
    @Generated
    private final Long expiresAt;

    /*
     * The Unix timestamp, in seconds, representing when this item was started.
     */
    @Generated
    private final Long startedAt;

    /*
     * The Unix timestamp, in seconds, representing when this completed.
     */
    @Generated
    private final Long completedAt;

    /*
     * The Unix timestamp, in seconds, representing when this was cancelled.
     */
    @Generated
    private final Long cancelledAt;

    /*
     * The Unix timestamp, in seconds, representing when this failed.
     */
    @Generated
    private final Long failedAt;

    /*
     * Details on why the run is incomplete. Will be `null` if the run is not incomplete.
     */
    @Generated
    private final IncompleteRunDetails incompleteDetails;

    /*
     * Usage statistics related to the run. This value will be `null` if the run is not in a terminal state (i.e.
     * `in_progress`, `queued`, etc.).
     */
    @Generated
    private final RunCompletionUsage usage;

    /*
     * The sampling temperature used for this run. If not set, defaults to 1.
     */
    @Generated
    private Double temperature;

    /*
     * The nucleus sampling value used for this run. If not set, defaults to 1.
     */
    @Generated
    private Double topP;

    /*
     * The maximum number of prompt tokens specified to have been used over the course of the run.
     */
    @Generated
    private final Integer maxPromptTokens;

    /*
     * The maximum number of completion tokens specified to have been used over the course of the run.
     */
    @Generated
    private final Integer maxCompletionTokens;

    /*
     * The strategy to use for dropping messages as the context windows moves forward.
     */
    @Generated
    private final TruncationObject truncationStrategy;

    /*
     * Controls whether or not and which tool is called by the model.
     */
    @Generated
    private final BinaryData toolChoice;

    /*
     * The response format of the tool calls used in this run.
     */
    @Generated
    private final BinaryData responseFormat;

    /*
     * A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information
     * about that object in a structured format. Keys may be up to 64 characters in length and values may be up to 512
     * characters in length.
     */
    @Generated
    private final Map<String, String> metadata;

    /*
     * Override the tools the agent can use for this run. This is useful for modifying the behavior on a per-run basis
     */
    @Generated
    private ToolResources toolResources;

    /*
     * Determines if tools can be executed in parallel within the run.
     */
    @Generated
    private final boolean parallelToolCalls;

    /**
     * Creates an instance of ThreadRun class.
     *
     * @param id the id value to set.
     * @param threadId the threadId value to set.
     * @param assistantId the assistantId value to set.
     * @param status the status value to set.
     * @param lastError the lastError value to set.
     * @param model the model value to set.
     * @param instructions the instructions value to set.
     * @param tools the tools value to set.
     * @param createdAt the createdAt value to set.
     * @param expiresAt the expiresAt value to set.
     * @param startedAt the startedAt value to set.
     * @param completedAt the completedAt value to set.
     * @param cancelledAt the cancelledAt value to set.
     * @param failedAt the failedAt value to set.
     * @param incompleteDetails the incompleteDetails value to set.
     * @param usage the usage value to set.
     * @param maxPromptTokens the maxPromptTokens value to set.
     * @param maxCompletionTokens the maxCompletionTokens value to set.
     * @param truncationStrategy the truncationStrategy value to set.
     * @param toolChoice the toolChoice value to set.
     * @param responseFormat the responseFormat value to set.
     * @param metadata the metadata value to set.
     * @param parallelToolCalls the parallelToolCalls value to set.
     */
    @Generated
    private ThreadRun(String id, String threadId, String assistantId, RunStatus status, RunError lastError,
        String model, String instructions, List<ToolDefinition> tools, OffsetDateTime createdAt,
        OffsetDateTime expiresAt, OffsetDateTime startedAt, OffsetDateTime completedAt, OffsetDateTime cancelledAt,
        OffsetDateTime failedAt, IncompleteRunDetails incompleteDetails, RunCompletionUsage usage,
        Integer maxPromptTokens, Integer maxCompletionTokens, TruncationObject truncationStrategy,
        BinaryData toolChoice, BinaryData responseFormat, Map<String, String> metadata, boolean parallelToolCalls) {
        this.id = id;
        this.threadId = threadId;
        this.assistantId = assistantId;
        this.status = status;
        this.lastError = lastError;
        this.model = model;
        this.instructions = instructions;
        this.tools = tools;
        if (createdAt == null) {
            this.createdAt = 0L;
        } else {
            this.createdAt = createdAt.toEpochSecond();
        }
        if (expiresAt == null) {
            this.expiresAt = null;
        } else {
            this.expiresAt = expiresAt.toEpochSecond();
        }
        if (startedAt == null) {
            this.startedAt = null;
        } else {
            this.startedAt = startedAt.toEpochSecond();
        }
        if (completedAt == null) {
            this.completedAt = null;
        } else {
            this.completedAt = completedAt.toEpochSecond();
        }
        if (cancelledAt == null) {
            this.cancelledAt = null;
        } else {
            this.cancelledAt = cancelledAt.toEpochSecond();
        }
        if (failedAt == null) {
            this.failedAt = null;
        } else {
            this.failedAt = failedAt.toEpochSecond();
        }
        this.incompleteDetails = incompleteDetails;
        this.usage = usage;
        this.maxPromptTokens = maxPromptTokens;
        this.maxCompletionTokens = maxCompletionTokens;
        this.truncationStrategy = truncationStrategy;
        this.toolChoice = toolChoice;
        this.responseFormat = responseFormat;
        this.metadata = metadata;
        this.parallelToolCalls = parallelToolCalls;
    }

    /**
     * Get the id property: The identifier, which can be referenced in API endpoints.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the object property: The object type, which is always 'thread.run'.
     *
     * @return the object value.
     */
    @Generated
    public String getObject() {
        return this.object;
    }

    /**
     * Get the threadId property: The ID of the thread associated with this run.
     *
     * @return the threadId value.
     */
    @Generated
    public String getThreadId() {
        return this.threadId;
    }

    /**
     * Get the assistantId property: The ID of the agent associated with the thread this run was performed against.
     *
     * @return the assistantId value.
     */
    @Generated
    public String getAssistantId() {
        return this.assistantId;
    }

    /**
     * Get the status property: The status of the agent thread run.
     *
     * @return the status value.
     */
    @Generated
    public RunStatus getStatus() {
        return this.status;
    }

    /**
     * Get the requiredAction property: The details of the action required for the agent thread run to continue.
     *
     * @return the requiredAction value.
     */
    @Generated
    public RequiredAction getRequiredAction() {
        return this.requiredAction;
    }

    /**
     * Get the lastError property: The last error, if any, encountered by this agent thread run.
     *
     * @return the lastError value.
     */
    @Generated
    public RunError getLastError() {
        return this.lastError;
    }

    /**
     * Get the model property: The ID of the model to use.
     *
     * @return the model value.
     */
    @Generated
    public String getModel() {
        return this.model;
    }

    /**
     * Get the instructions property: The overridden system instructions used for this agent thread run.
     *
     * @return the instructions value.
     */
    @Generated
    public String getInstructions() {
        return this.instructions;
    }

    /**
     * Get the tools property: The overridden enabled tools used for this agent thread run.
     *
     * @return the tools value.
     */
    @Generated
    public List<ToolDefinition> getTools() {
        return this.tools;
    }

    /**
     * Get the createdAt property: The Unix timestamp, in seconds, representing when this object was created.
     *
     * @return the createdAt value.
     */
    @Generated
    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    /**
     * Get the expiresAt property: The Unix timestamp, in seconds, representing when this item expires.
     *
     * @return the expiresAt value.
     */
    @Generated
    public OffsetDateTime getExpiresAt() {
        if (this.expiresAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expiresAt), ZoneOffset.UTC);
    }

    /**
     * Get the startedAt property: The Unix timestamp, in seconds, representing when this item was started.
     *
     * @return the startedAt value.
     */
    @Generated
    public OffsetDateTime getStartedAt() {
        if (this.startedAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.startedAt), ZoneOffset.UTC);
    }

    /**
     * Get the completedAt property: The Unix timestamp, in seconds, representing when this completed.
     *
     * @return the completedAt value.
     */
    @Generated
    public OffsetDateTime getCompletedAt() {
        if (this.completedAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.completedAt), ZoneOffset.UTC);
    }

    /**
     * Get the cancelledAt property: The Unix timestamp, in seconds, representing when this was cancelled.
     *
     * @return the cancelledAt value.
     */
    @Generated
    public OffsetDateTime getCancelledAt() {
        if (this.cancelledAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.cancelledAt), ZoneOffset.UTC);
    }

    /**
     * Get the failedAt property: The Unix timestamp, in seconds, representing when this failed.
     *
     * @return the failedAt value.
     */
    @Generated
    public OffsetDateTime getFailedAt() {
        if (this.failedAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.failedAt), ZoneOffset.UTC);
    }

    /**
     * Get the incompleteDetails property: Details on why the run is incomplete. Will be `null` if the run is not
     * incomplete.
     *
     * @return the incompleteDetails value.
     */
    @Generated
    public IncompleteRunDetails getIncompleteDetails() {
        return this.incompleteDetails;
    }

    /**
     * Get the usage property: Usage statistics related to the run. This value will be `null` if the run is not in a
     * terminal state (i.e. `in_progress`, `queued`, etc.).
     *
     * @return the usage value.
     */
    @Generated
    public RunCompletionUsage getUsage() {
        return this.usage;
    }

    /**
     * Get the temperature property: The sampling temperature used for this run. If not set, defaults to 1.
     *
     * @return the temperature value.
     */
    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    /**
     * Get the topP property: The nucleus sampling value used for this run. If not set, defaults to 1.
     *
     * @return the topP value.
     */
    @Generated
    public Double getTopP() {
        return this.topP;
    }

    /**
     * Get the maxPromptTokens property: The maximum number of prompt tokens specified to have been used over the course
     * of the run.
     *
     * @return the maxPromptTokens value.
     */
    @Generated
    public Integer getMaxPromptTokens() {
        return this.maxPromptTokens;
    }

    /**
     * Get the maxCompletionTokens property: The maximum number of completion tokens specified to have been used over
     * the course of the run.
     *
     * @return the maxCompletionTokens value.
     */
    @Generated
    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    /**
     * Get the truncationStrategy property: The strategy to use for dropping messages as the context windows moves
     * forward.
     *
     * @return the truncationStrategy value.
     */
    @Generated
    public TruncationObject getTruncationStrategy() {
        return this.truncationStrategy;
    }

    /**
     * Get the toolChoice property: Controls whether or not and which tool is called by the model.
     *
     * @return the toolChoice value.
     */
    @Generated
    public BinaryData getToolChoice() {
        return this.toolChoice;
    }

    /**
     * Get the responseFormat property: The response format of the tool calls used in this run.
     *
     * @return the responseFormat value.
     */
    @Generated
    public BinaryData getResponseFormat() {
        return this.responseFormat;
    }

    /**
     * Get the metadata property: A set of up to 16 key/value pairs that can be attached to an object, used for storing
     * additional information about that object in a structured format. Keys may be up to 64 characters in length and
     * values may be up to 512 characters in length.
     *
     * @return the metadata value.
     */
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Get the toolResources property: Override the tools the agent can use for this run. This is useful for modifying
     * the behavior on a per-run basis.
     *
     * @return the toolResources value.
     */
    @Generated
    public ToolResources getToolResources() {
        return this.toolResources;
    }

    /**
     * Get the parallelToolCalls property: Determines if tools can be executed in parallel within the run.
     *
     * @return the parallelToolCalls value.
     */
    @Generated
    public boolean isParallelToolCalls() {
        return this.parallelToolCalls;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeStringField("thread_id", this.threadId);
        jsonWriter.writeStringField("assistant_id", this.assistantId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("last_error", this.lastError);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("instructions", this.instructions);
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeNumberField("expires_at", this.expiresAt);
        jsonWriter.writeNumberField("started_at", this.startedAt);
        jsonWriter.writeNumberField("completed_at", this.completedAt);
        jsonWriter.writeNumberField("cancelled_at", this.cancelledAt);
        jsonWriter.writeNumberField("failed_at", this.failedAt);
        jsonWriter.writeJsonField("incomplete_details", this.incompleteDetails);
        jsonWriter.writeJsonField("usage", this.usage);
        jsonWriter.writeNumberField("max_prompt_tokens", this.maxPromptTokens);
        jsonWriter.writeNumberField("max_completion_tokens", this.maxCompletionTokens);
        jsonWriter.writeJsonField("truncation_strategy", this.truncationStrategy);
        jsonWriter.writeFieldName("tool_choice");
        this.toolChoice.writeTo(jsonWriter);
        jsonWriter.writeFieldName("response_format");
        this.responseFormat.writeTo(jsonWriter);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("parallel_tool_calls", this.parallelToolCalls);
        jsonWriter.writeJsonField("required_action", this.requiredAction);
        jsonWriter.writeNumberField("temperature", this.temperature);
        jsonWriter.writeNumberField("top_p", this.topP);
        jsonWriter.writeJsonField("tool_resources", this.toolResources);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ThreadRun from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ThreadRun if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ThreadRun.
     */
    @Generated
    public static ThreadRun fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            String threadId = null;
            String assistantId = null;
            RunStatus status = null;
            RunError lastError = null;
            String model = null;
            String instructions = null;
            List<ToolDefinition> tools = null;
            OffsetDateTime createdAt = null;
            OffsetDateTime expiresAt = null;
            OffsetDateTime startedAt = null;
            OffsetDateTime completedAt = null;
            OffsetDateTime cancelledAt = null;
            OffsetDateTime failedAt = null;
            IncompleteRunDetails incompleteDetails = null;
            RunCompletionUsage usage = null;
            Integer maxPromptTokens = null;
            Integer maxCompletionTokens = null;
            TruncationObject truncationStrategy = null;
            BinaryData toolChoice = null;
            BinaryData responseFormat = null;
            Map<String, String> metadata = null;
            boolean parallelToolCalls = false;
            RequiredAction requiredAction = null;
            Double temperature = null;
            Double topP = null;
            ToolResources toolResources = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("thread_id".equals(fieldName)) {
                    threadId = reader.getString();
                } else if ("assistant_id".equals(fieldName)) {
                    assistantId = reader.getString();
                } else if ("status".equals(fieldName)) {
                    status = RunStatus.fromString(reader.getString());
                } else if ("last_error".equals(fieldName)) {
                    lastError = RunError.fromJson(reader);
                } else if ("model".equals(fieldName)) {
                    model = reader.getString();
                } else if ("instructions".equals(fieldName)) {
                    instructions = reader.getString();
                } else if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ToolDefinition.fromJson(reader1));
                } else if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                } else if ("expires_at".equals(fieldName)) {
                    Long expiresAtHolder = reader.getNullable(JsonReader::getLong);
                    if (expiresAtHolder != null) {
                        expiresAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(expiresAtHolder), ZoneOffset.UTC);
                    }
                } else if ("started_at".equals(fieldName)) {
                    Long startedAtHolder = reader.getNullable(JsonReader::getLong);
                    if (startedAtHolder != null) {
                        startedAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(startedAtHolder), ZoneOffset.UTC);
                    }
                } else if ("completed_at".equals(fieldName)) {
                    Long completedAtHolder = reader.getNullable(JsonReader::getLong);
                    if (completedAtHolder != null) {
                        completedAt
                            = OffsetDateTime.ofInstant(Instant.ofEpochSecond(completedAtHolder), ZoneOffset.UTC);
                    }
                } else if ("cancelled_at".equals(fieldName)) {
                    Long cancelledAtHolder = reader.getNullable(JsonReader::getLong);
                    if (cancelledAtHolder != null) {
                        cancelledAt
                            = OffsetDateTime.ofInstant(Instant.ofEpochSecond(cancelledAtHolder), ZoneOffset.UTC);
                    }
                } else if ("failed_at".equals(fieldName)) {
                    Long failedAtHolder = reader.getNullable(JsonReader::getLong);
                    if (failedAtHolder != null) {
                        failedAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(failedAtHolder), ZoneOffset.UTC);
                    }
                } else if ("incomplete_details".equals(fieldName)) {
                    incompleteDetails = IncompleteRunDetails.fromJson(reader);
                } else if ("usage".equals(fieldName)) {
                    usage = RunCompletionUsage.fromJson(reader);
                } else if ("max_prompt_tokens".equals(fieldName)) {
                    maxPromptTokens = reader.getNullable(JsonReader::getInt);
                } else if ("max_completion_tokens".equals(fieldName)) {
                    maxCompletionTokens = reader.getNullable(JsonReader::getInt);
                } else if ("truncation_strategy".equals(fieldName)) {
                    truncationStrategy = TruncationObject.fromJson(reader);
                } else if ("tool_choice".equals(fieldName)) {
                    toolChoice
                        = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("response_format".equals(fieldName)) {
                    responseFormat
                        = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                } else if ("parallel_tool_calls".equals(fieldName)) {
                    parallelToolCalls = reader.getBoolean();
                } else if ("required_action".equals(fieldName)) {
                    requiredAction = RequiredAction.fromJson(reader);
                } else if ("temperature".equals(fieldName)) {
                    temperature = reader.getNullable(JsonReader::getDouble);
                } else if ("top_p".equals(fieldName)) {
                    topP = reader.getNullable(JsonReader::getDouble);
                } else if ("tool_resources".equals(fieldName)) {
                    toolResources = ToolResources.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            ThreadRun deserializedThreadRun
                = new ThreadRun(id, threadId, assistantId, status, lastError, model, instructions, tools, createdAt,
                    expiresAt, startedAt, completedAt, cancelledAt, failedAt, incompleteDetails, usage, maxPromptTokens,
                    maxCompletionTokens, truncationStrategy, toolChoice, responseFormat, metadata, parallelToolCalls);
            deserializedThreadRun.requiredAction = requiredAction;
            deserializedThreadRun.temperature = temperature;
            deserializedThreadRun.topP = topP;
            deserializedThreadRun.toolResources = toolResources;
            return deserializedThreadRun;
        });
    }
}
