// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An abstract representation of an input tool definition that an agent can use.
 */
@Immutable
public class ToolDefinition implements JsonSerializable<ToolDefinition> {

    /*
     * The object type.
     */
    @Generated
    private String type = "ToolDefinition";

    /**
     * Creates an instance of ToolDefinition class.
     */
    @Generated
    public ToolDefinition() {
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ToolDefinition from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ToolDefinition if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ToolDefinition.
     */
    @Generated
    public static ToolDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("file_search".equals(discriminatorValue)) {
                    return FileSearchToolDefinition.fromJson(readerToUse.reset());
                } else if ("function".equals(discriminatorValue)) {
                    return FunctionToolDefinition.fromJson(readerToUse.reset());
                } else if ("bing_grounding".equals(discriminatorValue)) {
                    return BingGroundingToolDefinition.fromJson(readerToUse.reset());
                } else if ("fabric_dataagent".equals(discriminatorValue)) {
                    return MicrosoftFabricToolDefinition.fromJson(readerToUse.reset());
                } else if ("sharepoint_grounding".equals(discriminatorValue)) {
                    return SharepointToolDefinition.fromJson(readerToUse.reset());
                } else if ("azure_ai_search".equals(discriminatorValue)) {
                    return AzureAISearchToolDefinition.fromJson(readerToUse.reset());
                } else if ("openapi".equals(discriminatorValue)) {
                    return OpenApiToolDefinition.fromJson(readerToUse.reset());
                } else if ("bing_custom_search".equals(discriminatorValue)) {
                    return BingCustomSearchToolDefinition.fromJson(readerToUse.reset());
                } else if ("connected_agent".equals(discriminatorValue)) {
                    return ConnectedAgentToolDefinition.fromJson(readerToUse.reset());
                } else if ("azure_function".equals(discriminatorValue)) {
                    return AzureFunctionToolDefinition.fromJson(readerToUse.reset());
                } else if ("code_interpreter".equals(discriminatorValue)) {
                    return CodeInterpreterToolDefinition.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static ToolDefinition fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ToolDefinition deserializedToolDefinition = new ToolDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedToolDefinition.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedToolDefinition;
        });
    }
}
