// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A set of resources that are used by the agent's tools. The resources are specific to the type of
 * tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search`
 * tool requires a list of vector store IDs.
 */
@Fluent
public final class ToolResources implements JsonSerializable<ToolResources> {

    /*
     * Resources to be used by the `code_interpreter` tool consisting of file IDs.
     */
    @Generated
    private CodeInterpreterToolResource codeInterpreter;

    /*
     * Resources to be used by the `file_search` tool consisting of vector store IDs.
     */
    @Generated
    private FileSearchToolResource fileSearch;

    /*
     * Resources to be used by the `azure_ai_search` tool consisting of index IDs and names.
     */
    @Generated
    private AzureAISearchToolResource azureAISearch;

    /**
     * Creates an instance of ToolResources class.
     */
    @Generated
    public ToolResources() {
    }

    /**
     * Get the codeInterpreter property: Resources to be used by the `code_interpreter` tool consisting of file IDs.
     *
     * @return the codeInterpreter value.
     */
    @Generated
    public CodeInterpreterToolResource getCodeInterpreter() {
        return this.codeInterpreter;
    }

    /**
     * Set the codeInterpreter property: Resources to be used by the `code_interpreter` tool consisting of file IDs.
     *
     * @param codeInterpreter the codeInterpreter value to set.
     * @return the ToolResources object itself.
     */
    @Generated
    public ToolResources setCodeInterpreter(CodeInterpreterToolResource codeInterpreter) {
        this.codeInterpreter = codeInterpreter;
        return this;
    }

    /**
     * Get the fileSearch property: Resources to be used by the `file_search` tool consisting of vector store IDs.
     *
     * @return the fileSearch value.
     */
    @Generated
    public FileSearchToolResource getFileSearch() {
        return this.fileSearch;
    }

    /**
     * Set the fileSearch property: Resources to be used by the `file_search` tool consisting of vector store IDs.
     *
     * @param fileSearch the fileSearch value to set.
     * @return the ToolResources object itself.
     */
    @Generated
    public ToolResources setFileSearch(FileSearchToolResource fileSearch) {
        this.fileSearch = fileSearch;
        return this;
    }

    /**
     * Get the azureAISearch property: Resources to be used by the `azure_ai_search` tool consisting of index IDs and
     * names.
     *
     * @return the azureAISearch value.
     */
    @Generated
    public AzureAISearchToolResource getAzureAISearch() {
        return this.azureAISearch;
    }

    /**
     * Set the azureAISearch property: Resources to be used by the `azure_ai_search` tool consisting of index IDs and
     * names.
     *
     * @param azureAISearch the azureAISearch value to set.
     * @return the ToolResources object itself.
     */
    @Generated
    public ToolResources setAzureAISearch(AzureAISearchToolResource azureAISearch) {
        this.azureAISearch = azureAISearch;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("code_interpreter", this.codeInterpreter);
        jsonWriter.writeJsonField("file_search", this.fileSearch);
        jsonWriter.writeJsonField("azure_ai_search", this.azureAISearch);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ToolResources from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ToolResources if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ToolResources.
     */
    @Generated
    public static ToolResources fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ToolResources deserializedToolResources = new ToolResources();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code_interpreter".equals(fieldName)) {
                    deserializedToolResources.codeInterpreter = CodeInterpreterToolResource.fromJson(reader);
                } else if ("file_search".equals(fieldName)) {
                    deserializedToolResources.fileSearch = FileSearchToolResource.fromJson(reader);
                } else if ("azure_ai_search".equals(fieldName)) {
                    deserializedToolResources.azureAISearch = AzureAISearchToolResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedToolResources;
        });
    }
}
