// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Controls for how a thread will be truncated prior to the run. Use this to control the initial
 * context window of the run.
 */
@Fluent
public final class TruncationObject implements JsonSerializable<TruncationObject> {

    /*
     * The truncation strategy to use for the thread. The default is `auto`. If set to `last_messages`, the thread will
     * be truncated to the `lastMessages` count most recent messages in the thread. When set to `auto`, messages in the
     * middle of the thread
     * will be dropped to fit the context length of the model, `max_prompt_tokens`.
     */
    @Generated
    private final TruncationStrategy type;

    /*
     * The number of most recent messages from the thread when constructing the context for the run.
     */
    @Generated
    private Integer lastMessages;

    /**
     * Creates an instance of TruncationObject class.
     *
     * @param type the type value to set.
     */
    @Generated
    public TruncationObject(TruncationStrategy type) {
        this.type = type;
    }

    /**
     * Get the type property: The truncation strategy to use for the thread. The default is `auto`. If set to
     * `last_messages`, the thread will
     * be truncated to the `lastMessages` count most recent messages in the thread. When set to `auto`, messages in the
     * middle of the thread
     * will be dropped to fit the context length of the model, `max_prompt_tokens`.
     *
     * @return the type value.
     */
    @Generated
    public TruncationStrategy getType() {
        return this.type;
    }

    /**
     * Get the lastMessages property: The number of most recent messages from the thread when constructing the context
     * for the run.
     *
     * @return the lastMessages value.
     */
    @Generated
    public Integer getLastMessages() {
        return this.lastMessages;
    }

    /**
     * Set the lastMessages property: The number of most recent messages from the thread when constructing the context
     * for the run.
     *
     * @param lastMessages the lastMessages value to set.
     * @return the TruncationObject object itself.
     */
    @Generated
    public TruncationObject setLastMessages(Integer lastMessages) {
        this.lastMessages = lastMessages;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeNumberField("last_messages", this.lastMessages);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TruncationObject from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of TruncationObject if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TruncationObject.
     */
    @Generated
    public static TruncationObject fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TruncationStrategy type = null;
            Integer lastMessages = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    type = TruncationStrategy.fromString(reader.getString());
                } else if ("last_messages".equals(fieldName)) {
                    lastMessages = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            TruncationObject deserializedTruncationObject = new TruncationObject(type);
            deserializedTruncationObject.lastMessages = lastMessages;
            return deserializedTruncationObject;
        });
    }
}
