// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Possible truncation strategies for the thread.
 */
public final class TruncationStrategy extends ExpandableStringEnum<TruncationStrategy> {

    /**
     * Default value. Messages in the middle of the thread will be dropped to fit the context length of the model.
     */
    @Generated
    public static final TruncationStrategy AUTO = fromString("auto");

    /**
     * The thread will truncate to the `lastMessages` count of recent messages.
     */
    @Generated
    public static final TruncationStrategy LAST_MESSAGES = fromString("last_messages");

    /**
     * Creates a new instance of TruncationStrategy value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public TruncationStrategy() {
    }

    /**
     * Creates or finds a TruncationStrategy from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding TruncationStrategy.
     */
    @Generated
    public static TruncationStrategy fromString(String name) {
        return fromString(name, TruncationStrategy.class);
    }

    /**
     * Gets known TruncationStrategy values.
     *
     * @return known TruncationStrategy values.
     */
    @Generated
    public static Collection<TruncationStrategy> values() {
        return values(TruncationStrategy.class);
    }
}
